/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.recipe;

import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.ThaumicAugmentationAPI;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;

public class MorphicArmorBindingRecipe
extends InfusionRecipe {
    public MorphicArmorBindingRecipe() {
        super("MORPHIC_ARMOR", (Object)ItemStack.field_190927_a, 8, new AspectList().add(Aspect.VOID, 100), (Object)ItemStack.field_190927_a, new Object[0]);
    }

    public boolean matches(List<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        EntityEquipmentSlot comp;
        if (input.size() != 3 || central.func_77973_b() == TAItems.MORPHIC_TOOL || central.func_77973_b() == ItemsTC.primordialPearl || !(central.func_77973_b() instanceof ItemArmor) || !ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{this.research})) {
            return false;
        }
        boolean morphicFound = false;
        boolean quicksilverFound = false;
        ItemStack disp = ItemStack.field_190927_a;
        for (ItemStack stack : input) {
            if (stack.func_77973_b() == ItemsTC.primordialPearl) {
                if (morphicFound) {
                    return false;
                }
                morphicFound = true;
                continue;
            }
            if (stack.func_77973_b() == ItemsTC.quicksilver) {
                if (quicksilverFound) {
                    return false;
                }
                quicksilverFound = true;
                continue;
            }
            if (!ThaumicAugmentationAPI.isCoremodAvailable() && stack.func_77973_b().hasContainerItem(stack)) {
                return false;
            }
            if (MorphicArmorHelper.hasMorphicArmor(stack)) {
                return false;
            }
            if (EntityLiving.func_184640_d((ItemStack)central) != EntityLiving.func_184640_d((ItemStack)stack)) {
                return false;
            }
            disp = stack;
        }
        EntityEquipmentSlot center = EntityLiving.func_184640_d((ItemStack)central);
        if (center != (comp = EntityLiving.func_184640_d((ItemStack)disp))) {
            return false;
        }
        return morphicFound && quicksilverFound;
    }

    public Object getRecipeOutput(EntityPlayer player, ItemStack input, List<ItemStack> comps) {
        ItemStack toReturn = input.func_77946_l();
        for (ItemStack stack : comps) {
            if (stack.func_77973_b() == ItemsTC.primordialPearl || stack.func_77973_b() == ItemsTC.quicksilver) continue;
            MorphicArmorHelper.setMorphicArmor(toReturn, stack);
            return toReturn;
        }
        return toReturn;
    }
}

