/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.tile.CapabilityRiftJar;
import thecodex6824.thaumicaugmentation.api.tile.IRiftJar;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;
import thecodex6824.thaumicaugmentation.api.util.RiftHelper;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.util.ISoundHandle;

public class TileRiftMoverOutput
extends TileEntity
implements ITickable,
IInteractWithCaster {
    protected boolean operating;
    protected EntityFluxRift rift;
    protected int targetSize;
    protected int lastSize;
    protected UUID loadedRiftUUID;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected ISoundHandle loop;

    @Nullable
    protected Vec3d findRiftPos() {
        Vec3d position = new Vec3d((Vec3i)this.field_174879_c.func_177984_a());
        for (int offset = 5; offset > 0; --offset) {
            Vec3d test = new Vec3d((Vec3i)this.field_174879_c.func_177981_b(offset));
            RayTraceResult trace = this.field_145850_b.func_72933_a(position, test);
            if (trace != null && trace.field_72307_f != null) continue;
            return test.func_72441_c(0.5, 0.5, 0.5);
        }
        return null;
    }

    @Nullable
    public Vec3d findLocalRiftPos() {
        Vec3d vec = this.findRiftPos();
        return vec != null ? vec.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) : null;
    }

    public boolean onCasterRightClick(World w, ItemStack stack, EntityPlayer player, BlockPos position, EnumFacing face, EnumHand hand) {
        if (!(this.field_145850_b.field_72995_K || this.operating || ModConfig.CONFIG_MISC.wussMode)) {
            Vec3d riftPos;
            IRiftJar jar;
            TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (below != null && (jar = (IRiftJar)below.getCapability(CapabilityRiftJar.RIFT_JAR, null)) != null && jar.hasRift() && (riftPos = this.findRiftPos()) != null) {
                List rifts = this.field_145850_b.func_72872_a(EntityFluxRift.class, new AxisAlignedBB(riftPos.field_72450_a, riftPos.field_72448_b, riftPos.field_72449_c, riftPos.field_72450_a, riftPos.field_72448_b, riftPos.field_72449_c).func_186662_g(32.0));
                if (rifts.isEmpty()) {
                    this.rift = new EntityFluxRift(this.field_145850_b);
                    EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
                    this.rift.func_70080_a(riftPos.field_72450_a, riftPos.field_72448_b, riftPos.field_72449_c, facing != null ? facing.func_185119_l() : 0.0f, 0.0f);
                    if (this.field_145850_b.func_72838_d((Entity)this.rift)) {
                        this.rift.setRiftSize(1);
                        this.rift.setRiftSeed(jar.getRift().getRiftSeed());
                        this.operating = true;
                        this.targetSize = jar.getRift().getRiftSize();
                        this.lastSize = 1;
                        this.func_70296_d();
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftstart, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    } else {
                        this.rift = null;
                        AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)jar.getRift().getRiftSize(), (boolean)true);
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                    jar.setRift(new FluxRiftReconstructor(0, 0));
                } else {
                    player.func_146105_b(new TextComponentTranslation("thaumicaugmentation.text.rift_too_close", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
                }
            }
            return true;
        }
        return this.field_145850_b.field_72995_K && !this.operating;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.operating) {
            if (this.rift != null) {
                if (this.rift.getCollapse()) {
                    this.rift.setCollapse(false);
                }
                this.rift.setRiftSize(0);
            }
            AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.targetSize, (boolean)true);
            this.operating = false;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
        } else if (this.field_145850_b.field_72995_K && this.loop != null) {
            this.loop.stop();
        }
        super.func_145843_s();
    }

    protected EntityFluxRift findRift() {
        BlockPos pos1 = this.field_174879_c.func_177982_a(-1, 1, -1);
        BlockPos pos2 = this.field_174879_c.func_177982_a(1, 6, 1);
        List rifts = this.field_145850_b.func_72872_a(EntityFluxRift.class, new AxisAlignedBB((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p(), (double)(pos2.func_177958_n() + 1), (double)(pos2.func_177956_o() + 1), (double)(pos2.func_177952_p() + 1)));
        if (!rifts.isEmpty()) {
            rifts.sort((rift1, rift2) -> (int)(rift1.func_180425_c().func_177951_i((Vec3i)this.field_174879_c) - rift2.func_180425_c().func_177951_i((Vec3i)this.field_174879_c)));
            for (EntityFluxRift maybe : rifts) {
                RayTraceResult trace = this.field_145850_b.func_72933_a(new Vec3d((Vec3i)this.field_174879_c.func_177982_a(0, 1, 0)), new Vec3d((Vec3i)maybe.func_180425_c()));
                if (trace != null && trace.field_72307_f != null) continue;
                return maybe;
            }
        }
        return null;
    }

    public void onLoad() {
        if (this.operating && this.loadedRiftUUID != null) {
            EntityFluxRift check = this.findRift();
            if (check != null && check.func_110124_au().equals(this.loadedRiftUUID)) {
                this.rift = check;
                if (this.loop != null) {
                    this.loop.stop();
                }
                this.loop = ThaumicAugmentation.proxy.playSpecialSound(TASounds.RIFT_MOVER_OUTPUT_LOOP, SoundCategory.BLOCKS, old -> this.operating && this.rift != null ? old : null, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 4.0f, 1.0f, true, 0);
            }
            this.loadedRiftUUID = null;
        }
    }

    protected int getParticleDelay(int size) {
        if (size < this.targetSize / 3) {
            return 5;
        }
        if ((double)size < (double)this.targetSize / 1.5) {
            return 10;
        }
        return 20;
    }

    public void func_73660_a() {
        if (this.operating) {
            if (!this.field_145850_b.field_72995_K && this.ticks++ % 10 == 0) {
                TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (this.rift == null || this.rift.field_70128_L || this.rift.getRiftSize() < 1 || this.rift.getCollapse() || this.rift.getRiftSize() < this.lastSize || below == null || !below.hasCapability(CapabilityRiftJar.RIFT_JAR, null)) {
                    if (this.rift != null) {
                        if (this.rift.getCollapse()) {
                            this.rift.setCollapse(false);
                        }
                        this.rift.setRiftSize(0);
                    }
                    AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.targetSize, (boolean)true);
                    this.operating = false;
                    this.func_70296_d();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                } else if ((double)AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.25f, (boolean)false) >= 0.2499) {
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VIS_OPERATION, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, 0.7, 0.875, 0.875, 0.85), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
                    this.rift.setRiftSize(this.rift.getRiftSize() + 1);
                    this.lastSize = this.rift.getRiftSize();
                    if (this.rift.getRiftSize() >= this.targetSize) {
                        this.rift = null;
                        this.operating = false;
                        this.func_70296_d();
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    }
                } else {
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VIS_OPERATION, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, 0.1, 0.15, 0.15, 0.85), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 64.0));
                }
            } else if (this.field_145850_b.field_72995_K) {
                if (this.loadedRiftUUID != null) {
                    this.rift = this.findRift();
                    if (this.rift != null && !this.rift.func_110124_au().equals(this.loadedRiftUUID)) {
                        this.rift = null;
                    }
                    this.loadedRiftUUID = null;
                }
                if (this.rift != null && this.ticks % this.getParticleDelay(this.rift.getRiftSize()) == 0) {
                    Vec3d particleDest = RiftHelper.pickRandomPointOnRift(this.rift).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                    Vec3d dir = particleDest.func_178788_d(new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5)).func_72432_b();
                    ThaumicAugmentation.proxy.getRenderHelper().renderRiftMoverParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, dir.field_72450_a * 0.25, dir.field_72448_b * 0.25, dir.field_72449_c * 0.25);
                    if (!TAConfig.reducedEffects.getValue().booleanValue()) {
                        particleDest = RiftHelper.pickRandomPointOnRift(this.rift).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                        ThaumicAugmentation.proxy.getRenderHelper().renderSpark(this.field_145850_b, particleDest.field_72450_a, particleDest.field_72448_b, particleDest.field_72449_c, 5.0f + this.field_145850_b.field_73012_v.nextFloat() * 7.5f, Aspect.ELDRITCH.getColor(), false);
                        if (this.field_145850_b.field_73012_v.nextBoolean()) {
                            particleDest = RiftHelper.pickRandomPointOnRiftWithInstability(this.rift, this.ticks).func_72441_c(this.rift.field_70165_t, this.rift.field_70163_u, this.rift.field_70161_v);
                            ThaumicAugmentation.proxy.getRenderHelper().renderArc(this.field_145850_b, particleDest.field_72450_a, particleDest.field_72448_b, particleDest.field_72449_c, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, Aspect.ELDRITCH.getColor(), this.rift.field_70131_O / 2.0f);
                        }
                    }
                }
                ++this.ticks;
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("operating", this.operating);
        if (this.operating && this.rift != null) {
            tag.func_186854_a("rift", this.rift.func_110124_au());
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        EntityFluxRift check;
        this.operating = pkt.func_148857_g().func_74767_n("operating");
        if (this.operating && (check = this.findRift()) != null && check.func_110124_au().equals(pkt.func_148857_g().func_186857_a("rift"))) {
            this.rift = check;
            if (this.loop != null) {
                this.loop.stop();
            }
            this.loop = ThaumicAugmentation.proxy.playSpecialSound(TASounds.RIFT_MOVER_OUTPUT_LOOP, SoundCategory.BLOCKS, old -> this.operating && this.rift != null ? old : null, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, 4.0f, 1.0f, true, 0);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("operating", this.operating);
        if (this.operating && (this.rift != null || this.loadedRiftUUID != null)) {
            tag.func_186854_a("rift", this.rift != null ? this.rift.func_110124_au() : this.loadedRiftUUID);
        }
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("operating", this.operating);
        if (this.operating) {
            compound.func_74768_a("size", this.targetSize);
            compound.func_74768_a("lastSize", this.lastSize);
            if (this.rift != null) {
                compound.func_186854_a("rift", this.rift.func_110124_au());
            }
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.operating = compound.func_74767_n("operating");
        if (this.operating) {
            this.targetSize = compound.func_74762_e("size");
            this.lastSize = compound.func_74762_e("lastSize");
            this.loadedRiftUUID = compound.func_186857_a("rift");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IRiftJar jar;
        TileEntity below;
        Vec3d origin;
        AxisAlignedBB normal = super.getRenderBoundingBox();
        if (EntityUtils.hasGoggles((Entity)Minecraft.func_71410_x().field_71439_g) && (origin = this.findLocalRiftPos()) != null && (below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && (jar = (IRiftJar)below.getCapability(CapabilityRiftJar.RIFT_JAR, null)) != null && jar.hasRift()) {
            return normal.func_111270_a(jar.getRift().getBoundingBox().func_186662_g(0.5).func_72317_d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + origin.field_72448_b, (double)this.field_174879_c.func_177952_p()));
        }
        return normal;
    }
}

