/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import com.github.terminatornl.tickcentral.TickCentral;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;
import net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer;
import net.minecraftforge.fml.common.asm.transformers.FieldRedirectTransformer;
import net.minecraftforge.fml.common.asm.transformers.ModAPITransformer;
import net.minecraftforge.fml.common.asm.transformers.PatchingTransformer;
import net.minecraftforge.fml.common.asm.transformers.SideTransformer;
import net.minecraftforge.fml.common.asm.transformers.SoundEngineFixTransformer;
import net.minecraftforge.fml.common.asm.transformers.TerminalTransformer;

public class Compatibility {
    private static boolean applied = false;

    public static void FixTransformerOrdering() {
        if (applied) {
            return;
        }
        applied = true;
        try {
            Field transformerField = LaunchClassLoader.class.getDeclaredField("transformers");
            transformerField.setAccessible(true);
            List transformers = (List)transformerField.get(Compatibility.class.getClassLoader());
            transformerField.set(Compatibility.class.getClassLoader(), new OrderedArrayList(transformers, TickCentral.INSTANCE.getPrioritizedASMTransformers()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static class OrderedArrayList
    extends ArrayList<IClassTransformer> {
        public static OrderedArrayList INSTANCE;
        private final Collection<Map.Entry<Class<? extends IClassTransformer>, Integer>> bias;
        private final Field transformerField;
        private boolean needsSorting = true;

        public OrderedArrayList(List<IClassTransformer> list, Collection<Map.Entry<Class<? extends IClassTransformer>, Integer>> bias) throws NoSuchFieldException {
            super(list);
            if (INSTANCE != null) {
                throw new IllegalStateException("Only one instance can exists!");
            }
            this.bias = bias;
            this.transformerField = ASMTransformerWrapper.TransformerWrapper.class.getDeclaredField("parent");
            this.transformerField.setAccessible(true);
            this.sortSelf();
            INSTANCE = this;
        }

        public final byte[] transformAsPureFML(String name, String transformedName, byte[] basicClass) {
            Iterator it = super.iterator();
            while (it.hasNext()) {
                boolean allowed;
                IClassTransformer transformer = (IClassTransformer)it.next();
                boolean bl = allowed = transformer instanceof PatchingTransformer || transformer instanceof SideTransformer || transformer instanceof SoundEngineFixTransformer || transformer instanceof DeobfuscationTransformer || transformer instanceof AccessTransformer || transformer instanceof FieldRedirectTransformer || transformer instanceof TerminalTransformer || transformer instanceof ModAPITransformer;
                if (!allowed) continue;
                basicClass = transformer.transform(name, transformedName, basicClass);
            }
            return basicClass;
        }

        @Override
        public final boolean add(IClassTransformer transformer) {
            boolean val = super.add(transformer);
            this.needsSorting = true;
            return val;
        }

        @Override
        public final void add(int index, IClassTransformer transformer) {
            super.add(index, transformer);
            this.needsSorting = true;
        }

        @Override
        public Iterator<IClassTransformer> iterator() {
            if (this.needsSorting) {
                this.sortSelf();
            }
            return super.iterator();
        }

        private void sortSelf() {
            this.sort((one, two) -> {
                if (one instanceof ASMTransformerWrapper.TransformerWrapper) {
                    try {
                        one = (IClassTransformer)this.transformerField.get(one);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (two instanceof ASMTransformerWrapper.TransformerWrapper) {
                    try {
                        two = (IClassTransformer)this.transformerField.get(two);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                int r = 0;
                for (Map.Entry<Class<? extends IClassTransformer>, Integer> b : this.bias) {
                    if (b.getKey().isAssignableFrom(one.getClass())) {
                        r += b.getValue().intValue();
                    }
                    if (!b.getKey().isAssignableFrom(two.getClass())) continue;
                    r -= b.getValue().intValue();
                }
                return r;
            });
            this.needsSorting = false;
        }
    }
}

