/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.music;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.MusicInstrument;

public abstract class ItemInstrument
extends Item {
    public static final String INSTR_COOLDOWN_KEY = "cooldown";
    protected MusicInstrument instrument;
    protected SoundEvent sound;

    public MusicInstrument getInstrument() {
        return this.instrument;
    }

    public ItemInstrument setInstrument(MusicInstrument instrument) {
        this.instrument = Objects.requireNonNull(instrument);
        return this;
    }

    @Nullable
    public SoundEvent getSound() {
        return this.sound;
    }

    public ItemInstrument setSound(@Nullable SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    protected void useInstrument(ItemStack stack, Entity entity, int cooldown) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74762_e(INSTR_COOLDOWN_KEY) == 0) {
            if (!entity.field_70170_p.field_72995_K) {
                if (!entity.func_70093_af()) {
                    this.playMusic(stack, entity);
                } else {
                    this.playSelector(stack, entity);
                }
            }
            tag.func_74768_a(INSTR_COOLDOWN_KEY, cooldown);
        }
    }

    protected void playMusic(ItemStack stack, Entity entity) {
        TotemicAPI.get().music().playMusic(entity, this.instrument);
        this.spawnParticles((WorldServer)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false);
        if (this.sound != null) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void playSelector(ItemStack stack, Entity entity) {
        TotemicAPI.get().music().playSelector(entity, this.instrument);
        this.spawnParticles((WorldServer)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, true);
        if (this.sound != null) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void spawnParticles(WorldServer world, double x, double y, double z, boolean firework) {
        world.func_175739_a(EnumParticleTypes.NOTE, x, y + 1.2, z, 6, 0.5, 0.0, 0.5, 0.0, new int[0]);
        if (firework) {
            world.func_175739_a(EnumParticleTypes.FIREWORKS_SPARK, x, y + 1.2, z, 8, 0.5, 0.0, 0.5, 0.0, new int[0]);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && slot < InventoryPlayer.func_70451_h()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                return;
            }
            int cooldown = tag.func_74762_e(INSTR_COOLDOWN_KEY);
            if (cooldown > 0) {
                tag.func_74768_a(INSTR_COOLDOWN_KEY, --cooldown);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

