/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.equipment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.BlockTotemPole;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.item.ItemTotemic;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.totem.TileTotemPole;
import pokefenn.totemic.util.ItemUtil;

public class ItemTotemWhittlingKnife
extends ItemTotemic {
    public static final String KNIFE_TOTEM_KEY = "totem";
    public static final String TOTEM_BASE_PLACEHOLDER_NAME = "";
    private static List<String> totemList;

    public ItemTotemWhittlingKnife() {
        super("totem_whittling_knife");
        this.func_77625_d(1);
        this.func_77656_e(250);
        this.func_77642_a(this);
    }

    @SideOnly(value=Side.CLIENT)
    private static String getCarvingName(@Nullable TotemEffect effect) {
        return I18n.func_135052_a((String)(effect != null ? effect.getUnlocalizedName() : ModBlocks.totem_base.func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    @Nullable
    public static TotemEffect getCarvingEffect(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        String name = tag.func_74779_i(KNIFE_TOTEM_KEY);
        if (!name.equals(TOTEM_BASE_PLACEHOLDER_NAME)) {
            return (TotemEffect)TotemicRegistries.totemEffects().getValue(new ResourceLocation(name));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip1"), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip2"), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip3"), (Object[])new Object[]{ItemTotemWhittlingKnife.getCarvingName(ItemTotemWhittlingKnife.getCarvingEffect(stack))}));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)(this.func_77658_a() + ".display"), (Object[])new Object[]{ItemTotemWhittlingKnife.getCarvingName(ItemTotemWhittlingKnife.getCarvingEffect(stack))});
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemTotemWhittlingKnife.changeIndex(stack, true));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState newState;
        TotemEffect effect;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            player.func_184611_a(hand, ItemTotemWhittlingKnife.changeIndex(stack, true));
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        WoodVariant wood = WoodVariant.fromLog(state);
        if (wood == null) {
            if (state.func_177230_c().isWood((IBlockAccess)world, pos) && state.func_177230_c() != ModBlocks.stripped_cedar_log) {
                wood = WoodVariant.OAK;
            } else {
                return EnumActionResult.FAIL;
            }
        }
        if ((effect = ItemTotemWhittlingKnife.getCarvingEffect(stack)) != null) {
            newState = ModBlocks.totem_pole.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand).func_177226_a(BlockTotemPole.WOOD, (Comparable)((Object)wood));
            world.func_180501_a(pos, newState, 3);
            TileTotemPole tile = (TileTotemPole)world.func_175625_s(pos);
            tile.setEffect(effect);
        } else {
            newState = ModBlocks.totem_base.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand).func_177226_a(BlockTotemPole.WOOD, (Comparable)((Object)wood));
            world.func_180501_a(pos, newState, 3);
        }
        newState.func_177230_c().func_180633_a(world, pos, newState, (EntityLivingBase)player, stack);
        stack.func_77972_a(1, (EntityLivingBase)player);
        world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)state));
        return EnumActionResult.SUCCESS;
    }

    public static ItemStack changeIndex(ItemStack itemStack, boolean direction) {
        ItemStack stack;
        int index;
        if (totemList == null) {
            totemList = (List)Streams.stream(TotemicRegistries.totemEffects()).map(eff -> eff.getRegistryName().toString()).collect(ImmutableList.toImmutableList());
        }
        if ((index = totemList.indexOf(ItemUtil.getOrCreateTag(stack = itemStack.func_77946_l()).func_74779_i(KNIFE_TOTEM_KEY))) == -1) {
            index = direction ? 0 : totemList.size() - 1;
        } else if ((index += direction ? 1 : -1) >= totemList.size()) {
            index = -1;
        }
        String name = index != -1 ? totemList.get(index) : TOTEM_BASE_PLACEHOLDER_NAME;
        stack.func_77978_p().func_74778_a(KNIFE_TOTEM_KEY, name);
        return stack;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.func_77964_b(stack.func_77952_i() + 1);
        return stack;
    }
}

