/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.StrataLayer;
import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneType;
import exterminatorjeff.undergroundbiomes.api.names.SlabEntry;
import exterminatorjeff.undergroundbiomes.common.block.IgneousSpeleothem;
import exterminatorjeff.undergroundbiomes.common.block.MetamorphicSpeleothem;
import exterminatorjeff.undergroundbiomes.common.block.SedimentarySpeleothem;
import exterminatorjeff.undergroundbiomes.common.block.UBOre;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBStoneSlab;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBStoneWall;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import exterminatorjeff.undergroundbiomes.intermod.StonesRegistry;
import exterminatorjeff.undergroundbiomes.world.noise.NoiseGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.Loader;
import vazkii.quark.world.block.BlockSpeleothem;

public abstract class UBStoneReplacer
implements UBStrataColumnProvider {
    final UBBiome[] biomeList;
    final NoiseGenerator noiseGenerator;

    public UBStoneReplacer(UBBiome[] biomeList, NoiseGenerator noiseGenerator) {
        this.biomeList = biomeList;
        this.noiseGenerator = noiseGenerator;
        if (biomeList == null) {
            throw new RuntimeException();
        }
        if (noiseGenerator == null) {
            throw new RuntimeException();
        }
    }

    public abstract int[] getBiomeValues(Chunk var1);

    public void replaceStoneInChunk(World world, Chunk chunk, boolean sendUpdates) {
        boolean isQuarkLoaded = Loader.isModLoaded((String)"quark");
        int[] biomeValues = this.getBiomeValues(chunk);
        int xPos = chunk.func_76632_l().field_77276_a << 4;
        int zPos = chunk.func_76632_l().field_77275_b << 4;
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null || storage.func_76663_a()) continue;
            int yPos = storage.func_76662_d();
            if (yPos >= UBConfig.SPECIFIC.generationHeight()) {
                return;
            }
            BlockPos.MutableBlockPos currentBlockPos = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    UBBiome currentBiome = this.biomeList[biomeValues[(x << 4) + z]];
                    if (currentBiome == null) {
                        throw new RuntimeException("" + biomeValues[(x << 4) + z]);
                    }
                    currentBlockPos.func_181079_c(x, 0, z);
                    String biomeName = Objects.requireNonNull(chunk.func_177411_a((BlockPos)currentBlockPos, chunk.func_177412_p().func_72959_q()).getRegistryName()).toString();
                    int variation = (int)(this.noiseGenerator.noise((double)(xPos + x) / 55.533, (double)(zPos + z) / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                    block18: for (int y = 0; y < 16; ++y) {
                        UBStone block;
                        UBStone block2;
                        IBlockState strata;
                        currentBlockPos.func_181079_c(xPos + x, yPos + y, zPos + z);
                        IBlockState currentBlockState = storage.func_177485_a(x, y, z);
                        Block currentBlock = currentBlockState.func_177230_c();
                        if (Block.func_149680_a((Block)Blocks.field_150350_a, (Block)currentBlock) || Block.func_149680_a((Block)Blocks.field_150355_j, (Block)currentBlock) || currentBlock instanceof UBStone || currentBlock instanceof UBOre) continue;
                        if (currentBlock == Blocks.field_150348_b) {
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, currentBiome.getStrataBlockAtLayer(yPos + y + variation));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150418_aU && API.SETTINGS.replaceMonsterStone()) {
                            BlockSilverfish.EnumType silverFishType = (BlockSilverfish.EnumType)currentBlockState.func_177229_b((IProperty)BlockSilverfish.field_176378_a);
                            if (silverFishType == BlockSilverfish.EnumType.COBBLESTONE && !API.SETTINGS.replaceCobblestone() || silverFishType != BlockSilverfish.EnumType.STONE && !API.SETTINGS.replaceStoneBrick() || !((strata = currentBiome.getStrataBlockAtLayer(yPos + y + variation)).func_177230_c() instanceof UBStone)) continue;
                            block2 = (UBStone)strata.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.MONSTER_STONE).getBlock().func_176203_a(block2.func_176201_c(strata)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150347_e && API.SETTINGS.replaceCobblestone()) {
                            IBlockState strata2 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata2.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata2.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.COBBLE).getBlock().func_176203_a(block.func_176201_c(strata2)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150417_aV && API.SETTINGS.replaceStoneBrick()) {
                            IBlockState strata3 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata3.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata3.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.BRICK).getBlock().func_176203_a(block.func_176201_c(strata3)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150333_U && API.SETTINGS.replaceStoneSlab()) {
                            UBStoneSlab slab;
                            SlabEntry slabEntry;
                            BlockStoneSlab.EnumType typeVanilla = (BlockStoneSlab.EnumType)currentBlockState.func_177229_b((IProperty)BlockStoneSlab.field_176556_M);
                            BlockSlab.EnumBlockHalf enumBlockHalf = (BlockSlab.EnumBlockHalf)currentBlockState.func_177229_b((IProperty)BlockStoneSlab.field_176554_a);
                            IBlockState strata4 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata4.func_177230_c() instanceof UBStone)) continue;
                            UBStone block3 = (UBStone)strata4.func_177230_c();
                            switch (typeVanilla) {
                                case STONE: {
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block3.getStoneType(), UBStoneStyle.STONE).getSlab();
                                    break;
                                }
                                case COBBLESTONE: {
                                    if (!API.SETTINGS.replaceCobblestone()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block3.getStoneType(), UBStoneStyle.COBBLE).getSlab();
                                    break;
                                }
                                case SMOOTHBRICK: {
                                    if (!API.SETTINGS.replaceStoneBrick()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block3.getStoneType(), UBStoneStyle.BRICK).getSlab();
                                    break;
                                }
                                case SAND: {
                                    if (!API.SETTINGS.replaceSandstone()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block3.getStoneType(), UBStoneStyle.SANDSTONE).getSlab();
                                    break;
                                }
                                default: {
                                    continue block18;
                                }
                            }
                            if (slabEntry == null || (slab = (UBStoneSlab)slabEntry.getHalfSlab()) == null) continue;
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, this.withProperty(slab.func_176223_P().func_177226_a((IProperty)UBStoneSlab.field_176554_a, (Comparable)enumBlockHalf), slab.func_176551_l(), strata4.func_177229_b(slab.func_176551_l())));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150334_T && API.SETTINGS.replaceStoneSlab()) {
                            UBStoneSlab slab;
                            SlabEntry slabEntry;
                            BlockStoneSlab.EnumType typeVanilla = (BlockStoneSlab.EnumType)currentBlockState.func_177229_b((IProperty)BlockStoneSlab.field_176556_M);
                            strata = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata.func_177230_c() instanceof UBStone)) continue;
                            block2 = (UBStone)strata.func_177230_c();
                            switch (typeVanilla) {
                                case STONE: {
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.STONE).getSlab();
                                    break;
                                }
                                case COBBLESTONE: {
                                    if (!API.SETTINGS.replaceCobblestone()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.COBBLE).getSlab();
                                    break;
                                }
                                case SMOOTHBRICK: {
                                    if (!API.SETTINGS.replaceStoneBrick()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.BRICK).getSlab();
                                    break;
                                }
                                case SAND: {
                                    if (!API.SETTINGS.replaceSandstone()) continue block18;
                                    slabEntry = StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.SANDSTONE).getSlab();
                                    break;
                                }
                                default: {
                                    continue block18;
                                }
                            }
                            if (slabEntry == null || (slab = (UBStoneSlab)slabEntry.getFullSlab()) == null) continue;
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, this.withProperty(slab.func_176223_P(), slab.func_176551_l(), strata.func_177229_b(slab.func_176551_l())));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150463_bK && API.SETTINGS.replaceCobblestone() && API.SETTINGS.replaceStoneWall()) {
                            UBStoneWall wall;
                            BlockWall.EnumType typeVanilla = (BlockWall.EnumType)currentBlockState.func_177229_b((IProperty)BlockWall.field_176255_P);
                            strata = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata.func_177230_c() instanceof UBStone)) continue;
                            block2 = (UBStone)strata.func_177230_c();
                            switch (typeVanilla) {
                                case NORMAL: 
                                case MOSSY: {
                                    wall = (UBStoneWall)StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.COBBLE).getWall().getBlock();
                                    break;
                                }
                                default: {
                                    continue block18;
                                }
                            }
                            if (wall == null) continue;
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, wall.func_176203_a(block2.func_176201_c(strata)));
                            continue;
                        }
                        if (Objects.requireNonNull(currentBlock.getRegistryName()).toString().equals("biomesoplenty:grass") && currentBlockState.func_177228_b().toString().contains("=overgrown_stone") && API.SETTINGS.replaceOvergrown()) {
                            boolean snowy = (Boolean)currentBlockState.func_177229_b((IProperty)PropertyBool.func_177716_a((String)"snowy"));
                            strata = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata.func_177230_c() instanceof UBStone)) continue;
                            block2 = (UBStone)strata.func_177230_c();
                            if (!snowy) {
                                this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.OVERGROWN).getBlock().func_176203_a(block2.func_176201_c(strata)));
                                continue;
                            }
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block2.getStoneType(), UBStoneStyle.OVERGROWN_SNOWED).getBlock().func_176203_a(block2.func_176201_c(strata)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150341_Y && API.SETTINGS.replaceMossyCobblestone()) {
                            IBlockState strata5 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata5.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata5.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.MOSSY_COBBLE).getBlock().func_176203_a(block.func_176201_c(strata5)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150351_n && API.SETTINGS.replaceGravel() && !API.SETTINGS.replaceGravelExcludedBiomes().contains(biomeName)) {
                            IBlockState strata6 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata6.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata6.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.GRAVEL).getBlock().func_176203_a(block.func_176201_c(strata6)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150354_m && API.SETTINGS.replaceSand() && currentBlockState.func_177228_b().get((Object)BlockSand.field_176504_a) != BlockSand.EnumType.RED_SAND && !API.SETTINGS.replaceSandExcludedBiomes().contains(biomeName)) {
                            IBlockState strata7 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata7.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata7.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SAND).getBlock().func_176203_a(block.func_176201_c(strata7)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150435_aG && API.SETTINGS.replaceClay() && !API.SETTINGS.replaceClayExcludedBiomes().contains(biomeName)) {
                            IBlockState strata8 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata8.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata8.func_177230_c();
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.CLAY).getBlock().func_176203_a(block.func_176201_c(strata8)));
                            continue;
                        }
                        if (currentBlock == Blocks.field_150322_A && API.SETTINGS.replaceSandstone() && !API.SETTINGS.replaceSandExcludedBiomes().contains(biomeName)) {
                            IBlockState strata9 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata9.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata9.func_177230_c();
                            if (currentBlockState.func_177228_b().get((Object)BlockSandStone.field_176297_a) == BlockSandStone.EnumType.DEFAULT) {
                                this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SANDSTONE).getBlock().func_176203_a(block.func_176201_c(strata9)));
                                continue;
                            }
                            if (currentBlockState.func_177228_b().get((Object)BlockSandStone.field_176297_a) == BlockSandStone.EnumType.SMOOTH) {
                                this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SMOOTH_SANDSTONE).getBlock().func_176203_a(block.func_176201_c(strata9)));
                                continue;
                            }
                            if (currentBlockState.func_177228_b().get((Object)BlockSandStone.field_176297_a) != BlockSandStone.EnumType.CHISELED) continue;
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.CHISELED_SANDSTONE).getBlock().func_176203_a(block.func_176201_c(strata9)));
                            continue;
                        }
                        if (isQuarkLoaded && API.SETTINGS.replaceSpeleothems() && currentBlock instanceof BlockSpeleothem) {
                            IBlockState strata10 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                            if (!(strata10.func_177230_c() instanceof UBStone)) continue;
                            block = (UBStone)strata10.func_177230_c();
                            if (block.getStoneType() == UBStoneType.IGNEOUS) {
                                this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SPELEOTHEM).getBlock().func_176203_a(block.func_176201_c(strata10)).func_177226_a(IgneousSpeleothem.SIZE, (Comparable)((Object)IgneousSpeleothem.EnumSize.values()[Math.max(0, ((BlockSpeleothem.EnumSize)currentBlockState.func_177229_b((IProperty)BlockSpeleothem.SIZE)).ordinal())])));
                            }
                            if (block.getStoneType() == UBStoneType.METAMORPHIC) {
                                this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SPELEOTHEM).getBlock().func_176203_a(block.func_176201_c(strata10)).func_177226_a(MetamorphicSpeleothem.SIZE, (Comparable)((Object)MetamorphicSpeleothem.EnumSize.values()[Math.max(0, ((BlockSpeleothem.EnumSize)currentBlockState.func_177229_b((IProperty)BlockSpeleothem.SIZE)).ordinal())])));
                            }
                            if (block.getStoneType() != UBStoneType.SEDIMENTARY) continue;
                            this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, StonesRegistry.INSTANCE.stoneFor(block.getStoneType(), UBStoneStyle.SPELEOTHEM).getBlock().func_176203_a(block.func_176201_c(strata10)).func_177226_a(SedimentarySpeleothem.SIZE, (Comparable)((Object)SedimentarySpeleothem.EnumSize.values()[Math.max(0, ((BlockSpeleothem.EnumSize)currentBlockState.func_177229_b((IProperty)BlockSpeleothem.SIZE)).ordinal())])));
                            continue;
                        }
                        IBlockState strata11 = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                        Block strataBlock = strata11.func_177230_c();
                        if (!(strataBlock instanceof UBStone)) {
                            strata11 = currentBiome.filler;
                            strataBlock = strata11.func_177230_c();
                        }
                        if (!OresRegistry.INSTANCE.isUBified(strataBlock, currentBlockState) || !(strataBlock instanceof UBStone)) continue;
                        UBStone stone = (UBStone)strataBlock;
                        IBlockState ore = OresRegistry.INSTANCE.getUBifiedOre(stone, stone.func_176201_c(strata11), currentBlockState);
                        this.setBlock(world, storage, sendUpdates, x, y, z, (BlockPos)currentBlockPos, ore);
                    }
                }
            }
        }
    }

    protected <T extends Comparable<T>> IBlockState withProperty(IBlockState blockState, IProperty<T> property, Comparable<?> comparable) {
        return blockState.func_177226_a(property, comparable);
    }

    private void setBlock(World world, ExtendedBlockStorage storage, boolean sendUpdates, int x, int y, int z, BlockPos blockPos, IBlockState blockState) {
        storage.func_177484_a(x, y, z, blockState);
        if (sendUpdates) {
            world.func_184138_a(blockPos, Blocks.field_150348_b.func_176223_P(), blockState, 3);
        }
    }

    public abstract UBBiome UBBiomeAt(int var1, int var2);

    public void redoOres(World world) {
        HashMap<ChunkPos, ArrayList<BlockPos>> toRedo = OresRegistry.INSTANCE.forRedo((IBlockAccess)world);
        for (ChunkPos chunkID : toRedo.keySet()) {
            ArrayList<BlockPos> locations = toRedo.get(chunkID);
            Chunk chunk = world.func_72863_F().func_186026_b(chunkID.field_77276_a, chunkID.field_77275_b);
            if (chunk == null) continue;
            int[] biomeValues = this.getBiomeValues(chunk);
            for (BlockPos location : locations) {
                IBlockState currentBlockState = chunk.func_177435_g(location);
                UBBiome currentBiome = this.biomeList[biomeValues[((location.func_177958_n() & 0xF) << 4) + (location.func_177952_p() & 0xF)]];
                int variation = (int)(this.noiseGenerator.noise((double)location.func_177958_n() / 55.533, (double)location.func_177952_p() / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                IBlockState strata = currentBiome.getStrataBlockAtLayer(location.func_177956_o() + variation);
                Block strataBlock = strata.func_177230_c();
                if (!(strataBlock instanceof UBStone)) {
                    strata = currentBiome.filler;
                    strataBlock = strata.func_177230_c();
                }
                if (!OresRegistry.INSTANCE.isUBified(strataBlock, currentBlockState) || !(strataBlock instanceof UBStone)) continue;
                UBStone stone = (UBStone)strataBlock;
                IBlockState ore = OresRegistry.INSTANCE.getUBifiedOre(stone, stone.func_176201_c(strata), currentBlockState);
                chunk.func_177436_a(location, ore);
            }
        }
    }

    private UBStrataColumn strataColumn(final StrataLayer[] strata, final IBlockState fillerBlockCodes, final int variation) {
        return new UBStrataColumn(){

            @Override
            public IBlockState stone(int y) {
                if (y >= UBConfig.SPECIFIC.generationHeight()) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                for (StrataLayer stratum : strata) {
                    if (!stratum.heightInLayer(y + variation)) continue;
                    return stratum.filler;
                }
                return fillerBlockCodes;
            }

            @Override
            public IBlockState cobblestone(int height) {
                if (height >= UBConfig.SPECIFIC.generationHeight()) {
                    return Blocks.field_150347_e.func_176223_P();
                }
                IBlockState stone = this.stone(height);
                if (stone.func_177230_c() == API.IGNEOUS_STONE.getBlock()) {
                    return API.IGNEOUS_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                if (stone.func_177230_c() == API.METAMORPHIC_STONE.getBlock()) {
                    return API.METAMORPHIC_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                return stone;
            }

            @Override
            public IBlockState cobblestone() {
                IBlockState stone = this.stone();
                if (stone.func_177230_c() == API.IGNEOUS_STONE.getBlock()) {
                    return API.IGNEOUS_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                if (stone.func_177230_c() == API.METAMORPHIC_STONE.getBlock()) {
                    return API.METAMORPHIC_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                return stone;
            }

            @Override
            public IBlockState stone() {
                return fillerBlockCodes;
            }
        };
    }

    @Override
    public UBStrataColumn strataColumn(int x, int z) {
        UBBiome biome = this.UBBiomeAt(x, z);
        int variation = (int)(this.noiseGenerator.noise((double)x / 55.533, (double)z / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
        return this.strataColumn(biome.strata, biome.filler, variation);
    }
}

