/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import ic2.api.recipe.IBasicMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.Recipes;
import ic2.core.block.steam.TileEntityCokeKiln;
import ic2.core.recipe.MachineRecipeHelper;
import ic2.core.recipe.ScrapboxRecipeManager;
import ic2.core.recipe.dynamic.DynamicRecipe;
import ic2.core.recipe.dynamic.DynamicRecipeManager;
import ic2.core.recipe.dynamic.RecipeOutputFluidStack;
import ic2.core.recipe.dynamic.RecipeOutputIngredient;
import ic2.core.recipe.dynamic.RecipeOutputItemStack;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IC2Integration
extends AbstractIntegrationThread {
    IC2Integration() {
        super("Industrial Craft 2");
    }

    public String call() {
        try {
            this.fixMachineOutput(Recipes.centrifuge);
            this.fixMachineOutput(Recipes.compressor);
            this.fixMachineOutput(Recipes.blastfurnace);
            this.fixMachineOutput(Recipes.macerator);
            this.fixMachineOutput(Recipes.metalformerCutting);
            this.fixMachineOutput(Recipes.metalformerExtruding);
            this.fixMachineOutput(Recipes.metalformerRolling);
            this.fixMachineOutput(Recipes.blockcutter);
            this.fixMachineOutput(Recipes.extractor);
            this.fixMachineOutput(Recipes.oreWashing);
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        try {
            this.fixScrapBoxDrops();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        try {
            this.fixCokeKilnRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "The world appears to be entirely industrialized.";
    }

    private void fixMachineOutput(@Nonnull IBasicMachineRecipeManager iBasicMachineRecipeManager) {
        Map recipes = (Map)Util.getField(MachineRecipeHelper.class, (String)"recipes", (Object)iBasicMachineRecipeManager, Map.class);
        Map recipeCache = (Map)Util.getField(MachineRecipeHelper.class, (String)"recipeCache", (Object)iBasicMachineRecipeManager, Map.class);
        List uncacheableRecipes = (List)Util.getField(MachineRecipeHelper.class, (String)"uncacheableRecipes", (Object)iBasicMachineRecipeManager, List.class);
        if (recipes != null) {
            for (Map.Entry entry : recipes.entrySet()) {
                entry.setValue(this.fixMachineRecipe((MachineRecipe<IRecipeInput, Collection<ItemStack>>)((MachineRecipe)entry.getValue())));
            }
        }
        if (recipeCache != null) {
            recipeCache.forEach((item, recipeList) -> recipeList.replaceAll(this::fixMachineRecipe));
        }
        if (uncacheableRecipes != null) {
            uncacheableRecipes.replaceAll(this::fixMachineRecipe);
        }
    }

    private MachineRecipe<IRecipeInput, Collection<ItemStack>> fixMachineRecipe(@Nonnull MachineRecipe<IRecipeInput, Collection<ItemStack>> machineRecipe) {
        return new MachineRecipe(machineRecipe.getInput(), this.resourceHandler.getMainItemStacks((Collection)machineRecipe.getOutput()), machineRecipe.getMetaData());
    }

    private void fixScrapBoxDrops() {
        Constructor<?> dropConstructor;
        Class<?>[] classes = ScrapboxRecipeManager.class.getDeclaredClasses();
        Class<?> actualClass = null;
        for (Class<?> clas : classes) {
            if (!clas.getName().equals("ic2.core.recipe.ScrapboxRecipeManager$Drop")) continue;
            actualClass = clas;
            break;
        }
        if (actualClass == null) {
            return;
        }
        Class<?> dropClass = actualClass;
        try {
            dropConstructor = dropClass.getDeclaredConstructor(ItemStack.class, Float.TYPE);
            dropConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        List dropList = (List)Util.getField(ScrapboxRecipeManager.class, (String)"drops", (Object)Recipes.scrapboxDrops, List.class);
        ArrayList newDrops = new ArrayList();
        dropList.forEach(drop -> {
            try {
                newDrops.add(dropConstructor.newInstance(this.resourceHandler.getMainItemStack((ItemStack)Util.getField((Class)dropClass, (String)"item", (Object)drop, ItemStack.class)), Util.getField((Class)dropClass, (String)"originalChance", (Object)drop, Float.class)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        dropList.clear();
        dropList.addAll(newDrops);
    }

    private void fixCokeKilnRecipes() {
        try {
            Class.forName("ic2.core.block.steam.TileEntityCokeKiln");
            DynamicRecipeManager recipeManager = TileEntityCokeKiln.recipeManager;
            Map recipes = (Map)Util.getField(DynamicRecipeManager.class, (String)"recipes", (Object)recipeManager, Map.class);
            Map recipeCacheItem = (Map)Util.getField(DynamicRecipeManager.class, (String)"recipeCacheItem", (Object)recipeManager, Map.class);
            Map recipeCacheFluid = (Map)Util.getField(DynamicRecipeManager.class, (String)"recipeCacheFluid", (Object)recipeManager, Map.class);
            List uncacheableRecipes = (List)Util.getField(DynamicRecipeManager.class, (String)"uncacheableRecipes", (Object)recipeManager, List.class);
            if (recipes == null || recipeCacheItem == null || recipeCacheFluid == null || uncacheableRecipes == null) {
                return;
            }
            recipeCacheItem.clear();
            recipeCacheFluid.clear();
            uncacheableRecipes.clear();
            ArrayList<DynamicRecipe> toRegister = new ArrayList<DynamicRecipe>();
            Iterator recipeIterator = recipes.values().iterator();
            while (recipeIterator.hasNext()) {
                DynamicRecipe recipe = (DynamicRecipe)recipeIterator.next();
                ArrayList<Object> newOutputs = new ArrayList<Object>();
                boolean skip = false;
                for (RecipeOutputIngredient outputIngredient : recipe.getOutputIngredients()) {
                    if (outputIngredient instanceof RecipeOutputFluidStack) {
                        newOutputs.add(outputIngredient);
                        continue;
                    }
                    if (outputIngredient instanceof RecipeOutputItemStack) {
                        RecipeOutputItemStack itemStack = (RecipeOutputItemStack)outputIngredient;
                        newOutputs.add(RecipeOutputItemStack.of((ItemStack)this.resourceHandler.getMainItemStack((ItemStack)itemStack.ingredient)));
                        continue;
                    }
                    skip = true;
                }
                if (skip) continue;
                toRegister.add(new DynamicRecipe(recipeManager).withInput(recipe.getInputIngredients()).withOutput(newOutputs).withMetadata(recipe.getMetadata()).withOperationDurationTicks(recipe.getOperationDuration()).withOperationEnergyCost(recipe.getOperationEnergyCost()));
                recipeIterator.remove();
            }
            toRegister.forEach(DynamicRecipe::register);
        }
        catch (ClassNotFoundException e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
    }
}

