/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import wanion.lib.common.IController;
import wanion.lib.common.ICopyable;
import wanion.lib.common.WContainer;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.network.NetworkHelper;

public class MatchingController
implements IController<MatchingController, AbstractMatching<?>> {
    private final Int2ObjectMap<AbstractMatching<?>> matchingControlMap = new Int2ObjectOpenHashMap();
    private final Collection<AbstractMatching<?>> values = this.matchingControlMap.values();
    private final IInventory inventory;

    public MatchingController(@Nonnull IInventory inventory) {
        this.inventory = inventory;
    }

    public MatchingController(@Nonnull IInventory inventory, AbstractMatching<?> ... matchings) {
        this(inventory);
        this.add(matchings);
    }

    public MatchingController(@Nonnull IInventory inventory, @Nonnull List<AbstractMatching<?>> matchingList) {
        this(inventory);
        matchingList.forEach(xva$0 -> this.add((AbstractMatching<?>)xva$0));
    }

    public MatchingController(@Nonnull IInventory inventory, @Nonnull Int2ObjectMap<AbstractMatching<?>> matchingMap) {
        this(inventory);
        this.matchingControlMap.putAll(matchingMap);
    }

    public void add(AbstractMatching<?> ... matchings) {
        for (AbstractMatching<?> matching : matchings) {
            this.matchingControlMap.put(matching.getNumber(), matching);
        }
    }

    public Collection<AbstractMatching<?>> getInstances() {
        return this.values;
    }

    public AbstractMatching<?> getMatching(int number) {
        return (AbstractMatching)this.matchingControlMap.get(number);
    }

    @Override
    @Nonnull
    public List<AbstractMatching<?>> compareContents(@Nonnull MatchingController otherMatchingController) {
        ArrayList differences = new ArrayList();
        for (AbstractMatching<?> matching : this.values) {
            AbstractMatching otherMatching;
            if (matching.equals(otherMatching = (AbstractMatching)otherMatchingController.matchingControlMap.get(matching.hashCode()))) continue;
            differences.add(matching);
        }
        return differences;
    }

    @Override
    public void addListener(int windowId, @Nonnull WContainer<?> wContainer, @Nonnull EntityPlayerMP entityPlayerMP) {
        NetworkHelper.addMatchingListener(windowId, wContainer, entityPlayerMP);
    }

    @Override
    public void detectAndSendChanges(int windowId, @Nonnull WContainer<?> wContainer) {
        NetworkHelper.detectAndSendMatchingChanges(windowId, wContainer);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound matchingNBT = new NBTTagCompound();
        NBTTagList matchingTagList = new NBTTagList();
        matchingNBT.func_74782_a("matching", (NBTBase)matchingTagList);
        this.values.forEach(matching -> matchingTagList.func_74742_a((NBTBase)matching.writeNBT()));
        return matchingNBT;
    }

    @Override
    public void afterWriteNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList matchingTagList = smartNBT.func_150295_c("matching", 10);
        if (matchingTagList.func_82582_d()) {
            return;
        }
        for (int i = 0; i < matchingTagList.func_74745_c(); ++i) {
            NBTTagCompound matchingTag = matchingTagList.func_150305_b(i);
            AbstractMatching matching = (AbstractMatching)this.matchingControlMap.get(matchingTag.func_74762_e("number"));
            if (matching == null) continue;
            matching.afterWriteNBT(matchingTag);
        }
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList matchingTagList = smartNBT.func_150295_c("matching", 10);
        if (matchingTagList.func_82582_d()) {
            return;
        }
        for (int i = 0; i < matchingTagList.func_74745_c(); ++i) {
            NBTTagCompound matchingTag = matchingTagList.func_150305_b(i);
            AbstractMatching matching = (AbstractMatching)this.matchingControlMap.get(matchingTag.func_74762_e("number"));
            if (matching == null) continue;
            matching.readNBT(matchingTag);
        }
        this.inventory.func_70296_d();
    }

    @Override
    @Nonnull
    public MatchingController copy() {
        return new MatchingController(this.inventory, this.values.stream().map(ICopyable::copy).collect(Collectors.toList()));
    }
}

