/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.wawla.config.Configurable;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@WawlaFeature(description="Shows descriptions of enchantments on enchantment books", name="enchdesc", type=ProviderType.ITEM)
public class PluginEnchantmentDescription
extends InfoProvider {
    @Configurable(category="enchdesc", description="Should the mod which added the enchantment be shown?")
    public static boolean showOwner = true;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemInfo(List<String> info, ItemStack stack, ITooltipFlag flag, EntityPlayer entityPlayer) {
        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
                ItemEnchantedBook item = (ItemEnchantedBook)stack.func_77973_b();
                List<Enchantment> enchants = this.getEnchantments(item, stack);
                for (Enchantment enchant : enchants) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.name", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)enchant.func_77320_a(), (Object[])new Object[0]));
                    info.add(this.getDescription(enchant));
                    if (!showOwner) continue;
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.addedby", (Object[])new Object[0]) + ": " + ChatFormatting.BLUE + PluginEnchantmentDescription.getModName(enchant));
                }
            } else {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.enchdesc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, keyBindSneak.getDisplayName(), ChatFormatting.GRAY}));
            }
        }
    }

    @Override
    public boolean canEnable() {
        return !Loader.isModLoaded((String)"enchdesc") && FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT);
    }

    @SideOnly(value=Side.CLIENT)
    private String getDescription(Enchantment enchantment) {
        String key = PluginEnchantmentDescription.getTranslationKey(enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.wawla.enchdesc.missing", (Object[])new Object[]{PluginEnchantmentDescription.getModName(enchantment), key});
        }
        return description;
    }

    @SideOnly(value=Side.CLIENT)
    private List<Enchantment> getEnchantments(ItemEnchantedBook book, ItemStack stack) {
        NBTTagList enchTags = ItemEnchantedBook.func_92110_g((ItemStack)stack);
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (enchTags != null) {
            for (int index = 0; index < enchTags.func_74745_c(); ++index) {
                short id = enchTags.func_150305_b(index).func_74765_d("id");
                Enchantment enchant = Enchantment.func_185262_c((int)id);
                if (enchant == null) continue;
                enchantments.add(enchant);
            }
        }
        return enchantments;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getModName(IForgeRegistryEntry.Impl<?> registerable) {
        String modID = registerable.getRegistryName().func_110624_b();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modID);
        return mod != null ? mod.getName() : modID;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getTranslationKey(Enchantment enchant) {
        return String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a());
    }
}

