/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.commands;

import com.agricraft.agricore.util.MathHelper;
import com.agricraft.agricore.util.TypeHelper;
import com.google.common.collect.ComparisonChain;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.utility.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandStat
implements ICommand {
    public String func_71517_b() {
        return "ac.stat";
    }

    public String func_71518_a(ICommandSender ics) {
        return "ac.stat <set|get> <growth|gain|strength|all> <value>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer ms, ICommandSender ics, String[] arguments) throws CommandException {
        if (arguments.length < 1) {
            throw new CommandException("Too few arguments to command! Expected \"set\" or \"get\" as first argument!", new Object[0]);
        }
        String action = arguments[0].trim().toLowerCase();
        if (action.equals("get") && arguments.length != 2) {
            throw new CommandException("Incorrect number of arguments!", new Object[0]);
        }
        if (action.equals("set") && arguments.length != 3) {
            throw new CommandException("Incorrect number of arguments!", new Object[0]);
        }
        EntityPlayer player = TypeHelper.cast(ics.func_174793_f(), EntityPlayer.class).orElseThrow(() -> new CommandException("Command must be invoked by a player!", new Object[0]));
        ItemStack stack = Optional.ofNullable(player.func_184614_ca()).filter(StackHelper::isValid).orElseThrow(() -> new CommandException("Player must be holding valid itemstack to be used as a target!", new Object[0]));
        IAgriStat stat = AgriApi.getStatRegistry().valueOf(stack).orElseThrow(() -> new CommandException("Player must be holding an AgriCraft seed item.", new Object[0]));
        switch (action) {
            case "get": {
                this.getStat(player, stack, stat, arguments[1].trim().toLowerCase());
                return;
            }
            case "set": {
                int value = MathHelper.parseIntOr(arguments[2], -1);
                this.setStat(player, stack, stat, arguments[1].trim().toLowerCase(), value);
                return;
            }
        }
        throw new CommandException("Invalid action: \"%s\"!", new Object[]{action});
    }

    private void setStat(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nonnull IAgriStat stat, @Nonnull String target, @Nonnull int value) throws CommandException {
        switch (target) {
            case "growth": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Growth: {0} -> {1}", (Object[])new Object[]{stat.getGrowth(), value});
                stat.withGrowth(value);
                break;
            }
            case "gain": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Gain: {0} -> {1}", (Object[])new Object[]{stat.getGain(), value});
                stat.withGain(value);
                break;
            }
            case "strength": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Strength: {0} -> {1}", (Object[])new Object[]{stat.getStrength(), value});
                stat.withStrength(value);
                break;
            }
            case "all": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Growth: {0} -> {1}", (Object[])new Object[]{stat.getGrowth(), value});
                stat.withGrowth(value);
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Gain: {0} -> {1}", (Object[])new Object[]{stat.getGain(), value});
                stat.withGain(value);
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Strength: {0} -> {1}", (Object[])new Object[]{stat.getStrength(), value});
                stat.withStrength(value);
                break;
            }
            default: {
                throw new CommandException("Invalid target: \"{0}\"!", new Object[]{target});
            }
        }
    }

    private void getStat(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nonnull IAgriStat stat, @Nonnull String target) throws CommandException {
        switch (target) {
            case "id": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"ID: {0}", (Object[])new Object[]{stat.getId()});
                break;
            }
            case "growth": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Growth: {0}", (Object[])new Object[]{stat.getGrowth()});
                break;
            }
            case "gain": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Gain: {0}", (Object[])new Object[]{stat.getGrowth()});
                break;
            }
            case "strength": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Strength: {0}", (Object[])new Object[]{stat.getGrowth()});
                break;
            }
            case "all": {
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"ID: {0}", (Object[])new Object[]{stat.getId()});
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Growth: {0}", (Object[])new Object[]{stat.getGrowth()});
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Gain: {0}", (Object[])new Object[]{stat.getGain()});
                MessageUtil.messagePlayer((EntityPlayer)player, (String)"Strength: {0}", (Object[])new Object[]{stat.getStrength()});
                break;
            }
            default: {
                throw new CommandException("Invalid target: \"%s\"!", new Object[]{target});
            }
        }
    }

    public boolean func_184882_a(MinecraftServer ms, ICommandSender ics) {
        return TypeHelper.cast(ics.func_174793_f(), EntityPlayer.class).filter(EntityPlayer::func_184812_l_).isPresent();
    }

    public List<String> func_184883_a(MinecraftServer ms, ICommandSender ics, String[] arguments, BlockPos bp) {
        ArrayList<String> completions = new ArrayList<String>();
        switch (arguments.length) {
            case 1: {
                completions.add("set");
                completions.add("get");
                break;
            }
            case 2: {
                completions.add("growth");
                completions.add("gain");
                completions.add("strength");
                completions.add("all");
                break;
            }
            case 3: {
                if (!arguments[0].trim().toLowerCase().equals("set")) break;
                completions.add(String.valueOf(0));
                completions.add(String.valueOf(AgriCraftConfig.cropStatCap));
            }
        }
        return completions;
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.func_71517_b()), (Comparable)((Object)o.func_71517_b())).result();
    }
}

