/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.utility.LightHelper;
import com.infinityraider.infinitylib.network.MessageBase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCompareLight
extends MessageBase<IMessage> {
    private String playerId;
    private int dimId;
    private BlockPos pos;
    private byte[] clientLightData;

    public MessageCompareLight() {
    }

    @SideOnly(value=Side.CLIENT)
    public MessageCompareLight(EntityPlayer player, World world, BlockPos pos) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        this.playerId = player.func_110124_au().toString();
        this.dimId = world.field_73011_w.getDimension();
        this.pos = pos;
        this.clientLightData = LightHelper.getLightData(world, pos);
    }

    public Side getMessageHandlerSide() {
        return Side.SERVER;
    }

    protected void processMessage(MessageContext ctx) {
        World world = AgriCraft.proxy.getWorldByDimensionId(this.dimId);
        EntityPlayer player = world.func_152378_a(UUID.fromString(this.playerId));
        byte[] serverLightData = LightHelper.getLightData(world, this.pos);
        LightHelper.messageLightData(player, this.clientLightData, serverLightData);
    }

    protected IMessage getReply(MessageContext ctx) {
        return null;
    }
}

