/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.ActionKey;
import appeng.client.EffectType;
import appeng.client.gui.AEBaseGui;
import appeng.client.render.crafting.ItemEncodedPatternBakedModel;
import appeng.client.render.effects.AssemblerFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.VibrantFX;
import appeng.client.render.model.UVLModelLoader;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.textures.ParticleTextures;
import appeng.container.interfaces.IJEIGhostIngredients;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.entity.EntityFloatingItem;
import appeng.entity.EntityTinyTNTPrimed;
import appeng.entity.RenderFloatingItem;
import appeng.entity.RenderTinyTNTPrimed;
import appeng.helpers.HighlighterHandler;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.TickHandler;
import appeng.server.ServerHelper;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class ClientHelper
extends ServerHelper {
    private static final String KEY_CATEGORY = "key.appliedenergistics2.category";
    private final EnumMap<ActionKey, KeyBinding> bindings = new EnumMap(ActionKey.class);

    @Override
    public void preinit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (!FMLClientHandler.instance().hasOptifine() && ForgeModContainer.forgeLightPipelineEnabled) {
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)UVLModelLoader.INSTANCE);
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityTinyTNTPrimed.class, manager -> new RenderTinyTNTPrimed(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFloatingItem.class, manager -> new RenderFloatingItem(manager));
    }

    @Override
    public void init() {
        for (ActionKey key : ActionKey.values()) {
            KeyBinding binding = new KeyBinding(key.getTranslationKey(), key.getDefaultKey(), KEY_CATEGORY);
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            this.bindings.put(key, binding);
        }
        Api.INSTANCE.definitions().items().encodedPattern().maybeItem().ifPresent(pattern -> Minecraft.func_71410_x().getItemColors().func_186730_a(ItemEncodedPatternBakedModel.PATTERN_ITEM_COLOR_HANDLER, new Item[]{pattern}));
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        HighlighterHandler.tick(event);
    }

    @Override
    public World getWorld() {
        if (Platform.isClient()) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return super.getWorld();
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class<? extends TileEntity> tile, AEBaseBlock blk) {
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        if (Platform.isClient()) {
            ArrayList<EntityPlayer> o = new ArrayList<EntityPlayer>();
            o.add((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return o;
        }
        return super.getPlayers();
    }

    @Override
    public void spawnEffect(EffectType effect, World world, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Assembler: {
                    this.spawnAssembler(world, posX, posY, posZ, o);
                    return;
                }
                case Vibrant: {
                    this.spawnVibrant(world, posX, posY, posZ);
                    return;
                }
                case Crafting: {
                    this.spawnCrafting(world, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(world, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(world, posX, posY, posZ);
                    return;
                }
                case LightningArc: {
                    this.spawnLightningArc(world, posX, posY, posZ, (Vec3d)o);
                    return;
                }
            }
        }
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        int setting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (setting == 2) {
            return false;
        }
        if (setting == 0) {
            return true;
        }
        return r.nextInt(2 * (setting + 1)) == 0;
    }

    @Override
    public RayTraceResult getRTR() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @Override
    public void postInit() {
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (Platform.isServer()) {
            return super.getRenderMode();
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        return this.renderModeForPlayer((EntityPlayer)player);
    }

    @Override
    public void triggerUpdates() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        int range = 256;
        mc.field_71441_e.func_147458_c(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @SubscribeEvent
    public void postPlayerRender(RenderLivingEvent.Pre p) {
        TickHandler.PlayerColor player = TickHandler.INSTANCE.getPlayerColors().get(p.getEntity().func_145782_y());
        if (player != null) {
            AEColor col = player.myColor;
            float r = 0xFF & col.mediumVariant >> 16;
            float g = 0xFF & col.mediumVariant >> 8;
            float b = 0xFF & col.mediumVariant;
            GlStateManager.func_179124_c((float)(r / 255.0f), (float)(g / 255.0f), (float)(b / 255.0f));
        }
    }

    private void spawnAssembler(World world, double posX, double posY, double posZ, Object o) {
        PacketAssemblerAnimation paa = (PacketAssemblerAnimation)o;
        AssemblerFX fx = new AssemblerFX(world, posX, posY, posZ, 0.0, 0.0, 0.0, paa.rate, paa.is);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnVibrant(World w, double x, double y, double z) {
        if (AppEng.proxy.shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            VibrantFX fx = new VibrantFX(w, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    private void spawnCrafting(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        CraftingFx fx = new CraftingFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.setMotionX(-x * 0.2f);
        fx.setMotionY(-y * 0.2f);
        fx.setMotionZ(-z * 0.2f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnEnergy(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        EnergyFx fx = new EnergyFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.setMotionX(-x * 0.1f);
        fx.setMotionY(-y * 0.1f);
        fx.setMotionZ(-z * 0.1f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnLightning(World world, double posX, double posY, double posZ) {
        LightningFX fx = new LightningFX(world, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnLightningArc(World world, double posX, double posY, double posZ, Vec3d second) {
        LightningArcFX fx = new LightningArcFX(world, posX, posY, posZ, second.field_72450_a, second.field_72448_b, second.field_72449_c, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    @SubscribeEvent
    public void MouseClickEvent(GuiScreenEvent.MouseInputEvent.Pre me) {
        AEBaseGui gui;
        Object ingredient;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof IJEIGhostIngredients && (ingredient = (gui = (AEBaseGui)mc.field_71462_r).getBookmarkedIngredient()) != null) {
            if (GuiScreen.func_146272_n()) {
                me.setCanceled(true);
            } else if (Mouse.isButtonDown((int)0)) {
                me.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.getDwheel() == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player.func_70093_af()) {
            boolean mainHand = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IMouseWheelItem;
            boolean offHand = player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                try {
                    NetworkHandler.instance().sendToServer(new PacketValueConfig("Item", me.getDwheel() > 0 ? "WheelUp" : "WheelDown"));
                    me.setCanceled(true);
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ParticleTextures.registerSprite(event);
        InscriberTESR.registerTexture(event);
    }

    @Override
    public boolean isKeyPressed(ActionKey key) {
        return this.bindings.get((Object)key).func_151468_f();
    }

    @Override
    public boolean isActionKey(ActionKey key, int pressedKeyCode) {
        return this.bindings.get((Object)key).isActiveAndMatches(pressedKeyCode);
    }
}

