/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.light;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientLightbeamHandler
implements ITickHandler {
    private int ticksExisted = 0;

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        ++this.ticksExisted;
        if (this.ticksExisted % 40 == 0) {
            this.ticksExisted = 0;
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            if (rView != null) {
                int dimId = rView.func_130014_f_().field_73011_w.getDimension();
                DataLightConnections connections = (DataLightConnections)SyncDataHolder.getDataClient("StarlightNetworkConnections");
                if (connections.clientReceivingData) {
                    return;
                }
                Map<BlockPos, List<BlockPos>> positions = connections.getClientConnections(dimId);
                if (positions != null) {
                    for (Map.Entry<BlockPos, List<BlockPos>> entry : positions.entrySet()) {
                        BlockPos at;
                        if (entry == null || !(rView.func_174818_b(at = entry.getKey()) <= (double)Config.maxEffectRenderDistanceSq)) continue;
                        Vector3 source = new Vector3(at).add(0.5, 0.5, 0.5);
                        Color overlay = null;
                        TileCrystalLens lens = MiscUtils.getTileAt((IBlockAccess)rView.func_130014_f_(), at, TileCrystalLens.class, true);
                        if (lens != null && lens.getLensColor() != null) {
                            overlay = lens.getLensColor().wrappedColor;
                        }
                        for (BlockPos dst : entry.getValue()) {
                            Vector3 to = new Vector3(dst).add(0.5, 0.5, 0.5);
                            EffectLightbeam beam = EffectHandler.getInstance().lightbeam(to, source, 0.6);
                            if (overlay == null) continue;
                            beam.setColorOverlay((float)overlay.getRed() / 255.0f, (float)overlay.getGreen() / 255.0f, (float)overlay.getBlue() / 255.0f, 1.0f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Client Lightbeam Display";
    }
}

