/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PartialEntityFlare;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.config.Config;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatreonEffectHelper {
    static boolean loadingFinished = false;
    static Map<UUID, List<PatreonEffect>> effectMap = new HashMap<UUID, List<PatreonEffect>>();

    @Nonnull
    public static List<PatreonEffect> getPatreonEffects(Side side, UUID uuid) {
        if (side == Side.CLIENT && !Config.enablePatreonEffects) {
            return Collections.emptyList();
        }
        if (!loadingFinished) {
            return Collections.emptyList();
        }
        return effectMap.getOrDefault(uuid, Collections.emptyList());
    }

    public static <T extends EntityPlayer> Map<UUID, List<PatreonEffect>> getPatreonEffects(Collection<T> players) {
        if (!loadingFinished) {
            return Maps.newHashMap();
        }
        Collection playerUUIDs = players.stream().map(Entity::func_110124_au).collect(Collectors.toList());
        return effectMap.entrySet().stream().filter(e -> playerUUIDs.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static enum FlareColor {
        BLUE(1407743, 12703999),
        DARK_RED(16713529, 0xFF5555),
        DAWN(16732550, 15293511),
        GOLD(16748822, 16773742),
        GREEN(6029111, 6553507),
        MAGENTA(0xFC7FFC, 0xFFC6FF),
        RED(16715563, 16715609),
        WHITE(0xBFFFFF, 0xFFFFFF),
        YELLOW(0xFFFF55, 16631583),
        ELDRITCH(6423168, 11412223),
        DARK_GREEN(50689, 0x22FF8F),
        FIRE(16728070, 0xFF9900),
        WATER(9035775, 5798621),
        EARTH(13665853, 13546386),
        AIR(0xFFFFD1, 11721405),
        STANDARD(10033337, 6184406);

        public final Color color1;
        public final Color color2;

        private FlareColor(int c1, int c2) {
            this.color1 = new Color(c1);
            this.color2 = new Color(c2);
        }

        public int spriteRowIndex() {
            return this.ordinal();
        }

        @SideOnly(value=Side.CLIENT)
        public SpriteSheetResource getTexture() {
            BindableResource texture = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "patreonflares/" + this.name().toLowerCase());
            return new SpriteSheetResource(texture, 1, 48);
        }
    }

    public static class PatreonEffect {
        protected static Random rand = new Random();
        private final FlareColor chosenColor;
        private final UUID sessionEffectId;

        public PatreonEffect(UUID sessionEffectId, FlareColor chosenColor) {
            this.chosenColor = chosenColor;
            this.sessionEffectId = sessionEffectId;
        }

        @Nullable
        public FlareColor getChosenColor() {
            return this.chosenColor;
        }

        public boolean hasPartialEntity() {
            return this.chosenColor != null;
        }

        public UUID getId() {
            return this.sessionEffectId;
        }

        public void initialize() {
        }

        @Nullable
        public PatreonPartialEntity createEntity(UUID playerUUID) {
            if (this.hasPartialEntity()) {
                return new PartialEntityFlare(this.getChosenColor(), playerUUID);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatreonEffect that = (PatreonEffect)o;
            return Objects.equals(this.sessionEffectId, that.sessionEffectId);
        }

        public int hashCode() {
            return Objects.hash(this.sessionEffectId);
        }
    }
}

