/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyNoArmor
extends KeyPerk {
    private float dmgReductionMultiplier = 0.7f;

    public KeyNoArmor(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyNoArmor.this.dmgReductionMultiplier = cfg.getFloat("ReductionMultiplier", this.getConfigurationSection(), KeyNoArmor.this.dmgReductionMultiplier, 0.05f, 1.0f, "The multiplier that is applied to damage the player receives. The lower the more damage is negated.");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.dmgReductionMultiplier = (float)((double)this.dmgReductionMultiplier * multiplier);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Side side;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        PlayerProgress prog = ResearchManager.getProgress(player, side = event.getEntityLiving().field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        if (prog.hasPerkEffect(this)) {
            int eq = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                ++eq;
            }
            if (eq < 2) {
                float effMulti = PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, "astralsorcery.perkeffect");
                event.setAmount(event.getAmount() * (this.dmgReductionMultiplier * (1.0f / effMulti)));
            }
        }
    }
}

