/*
 * Decompiled with CFR 0.152.
 */
package kiba.bhc.handler;

import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.base.Preconditions;
import java.util.UUID;
import kiba.bhc.handler.ConfigHandler;
import kiba.bhc.items.BaseHeartCanister;
import kiba.bhc.items.ItemHeartAmulet;
import kiba.bhc.util.HeartType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="bhc")
public class HealthHandler {
    private static final UUID HEALTH_MODIFIER = UUID.fromString("caa44aa0-9e6e-4a57-9759-d2f64abfb7d3");

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.field_71070_bA == event.player.field_71069_bz && event.player instanceof EntityPlayerMP && ((EntityPlayerMP)event.player).field_70170_p.func_82737_E() % 10L == 0L) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
                IBaublesItemHandler baublesInventory = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
                float diff = player.func_110138_aP() - player.func_110143_aJ();
                int[] hearts = new int[HeartType.values().length];
                for (int slot = 0; slot < baublesInventory.getSlots(); ++slot) {
                    ItemStack slotStack = baublesInventory.getStackInSlot(slot);
                    if (slotStack.func_190926_b()) continue;
                    if (slotStack.func_77973_b() instanceof BaseHeartCanister) {
                        HeartType type = ((BaseHeartCanister)slotStack.func_77973_b()).type;
                        int n = type.ordinal();
                        hearts[n] = hearts[n] + slotStack.func_190916_E() * 2;
                        continue;
                    }
                    if (!(slotStack.func_77973_b() instanceof ItemHeartAmulet)) continue;
                    int[] pendantHearts = ((ItemHeartAmulet)slotStack.func_77973_b()).getHeartCount(slotStack);
                    Preconditions.checkArgument((pendantHearts.length == HeartType.values().length ? 1 : 0) != 0, (Object)"Array must be same length as enum length!");
                    for (int i = 0; i < hearts.length; ++i) {
                        int n = i;
                        hearts[n] = hearts[n] + pendantHearts[i];
                    }
                }
                int extraHearts = 0;
                for (int i = 0; i < hearts.length; ++i) {
                    extraHearts += MathHelper.func_76125_a((int)hearts[i], (int)0, (int)(ConfigHandler.heartStackSize * 2));
                }
                AttributeModifier modifier = health.func_111127_a(HEALTH_MODIFIER);
                if (modifier != null) {
                    if (modifier.func_111164_d() == (double)extraHearts) {
                        return;
                    }
                    health.func_111124_b(modifier);
                }
                health.func_111121_a(new AttributeModifier(HEALTH_MODIFIER, "bhc:extra_hearts", (double)extraHearts, 0));
                float amount = MathHelper.func_76131_a((float)(player.func_110138_aP() - diff), (float)0.0f, (float)player.func_110138_aP());
                if (amount > 0.0f) {
                    player.func_70606_j(amount);
                } else {
                    player.func_71128_l();
                    player.func_174812_G();
                }
            }
        }
    }
}

