/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileCableBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u001a6\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00160\u001c\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"facingPos", "Lnet/minecraft/util/math/BlockPos;", "Lappeng/parts/AEBasePart;", "getFacingPos", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/util/math/BlockPos;", "facingTile", "Lnet/minecraft/tileentity/TileEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/tileentity/TileEntity;", "getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/IBlockAccess;", "pos", "getPart", "Lappeng/api/parts/IPart;", "hitX", "", "hitY", "hitZ", "listTargetGridP2P", "", "Lappeng/parts/p2p/PartP2PTunnel;", "grid", "Lappeng/api/networking/IGrid;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "clazz", "Ljava/lang/Class;", "betterp2p"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull IBlockAccess w, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntity te = w.func_175625_s(pos);
        ICableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = (ICableBusContainer)((TileCableBus)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull IBlockAccess w, @NotNull BlockPos pos, float hitX, float hitY, float hitZ) {
        SelectedPart p;
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        TileEntity te = w.func_175625_s(pos);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart selectedPart = p = ((IPartHost)te).selectPart(vec);
        return selectedPart != null ? selectedPart.part : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PartP2PTunnel<?>> listTargetGridP2P(@Nullable IGrid grid, @NotNull EntityPlayer player, @NotNull Class<? extends PartP2PTunnel<?>> clazz) {
        Object object;
        block7: {
            block6: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
                    return CollectionsKt.emptyList();
                }
                object = grid;
                if (object == null || (object = object.getMachines(clazz)) == null) break block6;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IGridNode iGridNode = (IGridNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    IGridHost iGridHost = v1.getMachine();
                    if (iGridHost == null) {
                        throw new TypeCastException("null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    }
                    PartP2PTunnel partP2PTunnel = (PartP2PTunnel)iGridHost;
                    collection.add(partP2PTunnel);
                }
                object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (object != null) break block7;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final BlockPos getFacingPos(@NotNull AEBasePart $this$facingPos) {
        BlockPos blockPos;
        Intrinsics.checkParameterIsNotNull((Object)$this$facingPos, (String)"$this$facingPos");
        IPartHost iPartHost = $this$facingPos.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getPos()) != null) {
            AEPartLocation aEPartLocation = $this$facingPos.getSide();
            if (aEPartLocation == null || (aEPartLocation = aEPartLocation.getFacing()) == null) {
                aEPartLocation = EnumFacing.UP;
            }
            blockPos = iPartHost.func_177972_a((EnumFacing)aEPartLocation);
        } else {
            blockPos = null;
        }
        return blockPos;
    }

    @Nullable
    public static final TileEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        BlockPos pos;
        Intrinsics.checkParameterIsNotNull((Object)$this$facingTile, (String)"$this$facingTile");
        IPartHost iPartHost = $this$facingTile.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPartHost, (String)"host");
        if (iPartHost.isInWorld() && (pos = CableBusUtilKt.getFacingPos($this$facingTile)) != null) {
            IPartHost iPartHost2 = $this$facingTile.getHost();
            return iPartHost2 != null && (iPartHost2 = iPartHost2.getLocation()) != null && (iPartHost2 = iPartHost2.getWorld()) != null ? iPartHost2.func_175625_s(pos) : null;
        }
        return null;
    }
}

