/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util.p2p;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import com.projecturanus.betterp2p.network.P2PInfo;
import com.projecturanus.betterp2p.util.p2p.P2PStatus;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u000f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a&\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007\u001a\u0016\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u001f\u001a\u00020\u0014\"\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0019\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\",\u0010\u000b\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\n\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"colorCode", "", "Lappeng/api/util/AEColor;", "Lappeng/parts/p2p/PartP2PTunnel;", "getColorCode", "(Lappeng/parts/p2p/PartP2PTunnel;)[Lappeng/api/util/AEColor;", "hasChannel", "", "getHasChannel", "(Lappeng/parts/p2p/PartP2PTunnel;)Z", "value", "outputProperty", "getOutputProperty", "setOutputProperty", "(Lappeng/parts/p2p/PartP2PTunnel;Z)V", "linkP2P", "Lkotlin/Pair;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "inputIndex", "", "outputIndex", "status", "Lcom/projecturanus/betterp2p/util/p2p/P2PStatus;", "updateP2P", "tunnel", "frequency", "", "output", "getInfo", "Lcom/projecturanus/betterp2p/network/P2PInfo;", "index", "betterp2p"})
public final class P2PUtilKt {
    @NotNull
    public static final AEColor[] getColorCode(@NotNull PartP2PTunnel<?> $this$colorCode) {
        Intrinsics.checkParameterIsNotNull($this$colorCode, (String)"$this$colorCode");
        AEColor[] aEColorArray = Platform.p2p().toColors($this$colorCode.getFrequency());
        Intrinsics.checkExpressionValueIsNotNull((Object)aEColorArray, (String)"Platform.p2p().toColors(this.frequency)");
        return aEColorArray;
    }

    @Nullable
    public static final Pair<PartP2PTunnel<?>, PartP2PTunnel<?>> linkP2P(@NotNull EntityPlayer player, int inputIndex, int outputIndex, @NotNull P2PStatus status) {
        IGrid grid;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        PartP2PTunnel<?> input = status.getListP2P().get(inputIndex);
        PartP2PTunnel<?> output = status.getListP2P().get(outputIndex);
        IGridNode iGridNode = input.getGridNode();
        Object object = grid = iGridNode != null ? iGridNode.getGrid() : null;
        if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
            return null;
        }
        if (Intrinsics.areEqual(input.getClass(), output.getClass()) ^ true) {
            return null;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        short frequency = input.getFrequency();
        AENetworkProxy aENetworkProxy = input.getProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)aENetworkProxy, (String)"input.proxy");
        P2PCache cache = aENetworkProxy.getP2P();
        if (input.getFrequency() == 0 || input.isOutput()) {
            frequency = cache.newFrequency();
            P2PUtilKt.updateP2P(input, frequency, false);
        }
        if (cache.getInputs(frequency, input.getClass()) != null) {
            TunnelCollection originalInputs = cache.getInputs(frequency, input.getClass());
            for (PartP2PTunnel originalInput : originalInputs) {
                if (!(Intrinsics.areEqual((Object)originalInput, input) ^ true)) continue;
                PartP2PTunnel partP2PTunnel = originalInput;
                Intrinsics.checkExpressionValueIsNotNull((Object)partP2PTunnel, (String)"originalInput");
                P2PUtilKt.updateP2P(partP2PTunnel, frequency, true);
            }
        }
        return TuplesKt.to(P2PUtilKt.updateP2P(input, frequency, false), P2PUtilKt.updateP2P(output, frequency, true));
    }

    @NotNull
    public static final PartP2PTunnel<?> updateP2P(@NotNull PartP2PTunnel<?> tunnel, short frequency, boolean output) {
        Intrinsics.checkParameterIsNotNull(tunnel, (String)"tunnel");
        AEPartLocation side = tunnel.getSide();
        tunnel.getHost().removePart(side, true);
        NBTTagCompound data = new NBTTagCompound();
        ItemStack itemStack = tunnel.getItemStack(PartItemStack.WRENCH);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"tunnel.getItemStack(PartItemStack.WRENCH)");
        ItemStack p2pItem = itemStack;
        String string = p2pItem.func_77977_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p2pItem.translationKey");
        String type = string;
        P2PUtilKt.setOutputProperty(tunnel, output);
        p2pItem.func_77955_b(data);
        data.func_74777_a("freq", frequency);
        AEColor[] colors = Platform.p2p().toColors(frequency);
        int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
        data.func_74783_a("colorCode", colorCode);
        ItemStack newType = new ItemStack(data);
        IPartHost iPartHost = tunnel.getHost();
        if (iPartHost == null || (iPartHost = iPartHost.addPart(newType, side, null, null)) == null) {
            throw (Throwable)new RuntimeException("Cannot bind");
        }
        IPartHost dir = iPartHost;
        IPart iPart = tunnel.getHost().getPart((AEPartLocation)dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)iPart, (String)"tunnel.host.getPart(dir)");
        IPart newBus = iPart;
        if (newBus instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newBus, output);
            try {
                AENetworkProxy aENetworkProxy = ((PartP2PTunnel)newBus).getProxy();
                Intrinsics.checkExpressionValueIsNotNull((Object)aENetworkProxy, (String)"newBus.proxy");
                P2PCache p2p = aENetworkProxy.getP2P();
                p2p.updateFreq((PartP2PTunnel)newBus, frequency);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            ((PartP2PTunnel)newBus).onTunnelNetworkChange();
            return (PartP2PTunnel)newBus;
        }
        throw (Throwable)new RuntimeException("Cannot bind");
    }

    public static final boolean getOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty) {
        Intrinsics.checkParameterIsNotNull($this$outputProperty, (String)"$this$outputProperty");
        return $this$outputProperty.isOutput();
    }

    public static final void setOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty, boolean value) {
        Field field;
        Intrinsics.checkParameterIsNotNull($this$outputProperty, (String)"$this$outputProperty");
        Field field2 = field = PartP2PTunnel.class.getDeclaredField("output");
        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
        field2.setAccessible(true);
        field.setBoolean($this$outputProperty, value);
    }

    public static final boolean getHasChannel(@NotNull PartP2PTunnel<?> $this$hasChannel) {
        Intrinsics.checkParameterIsNotNull($this$hasChannel, (String)"$this$hasChannel");
        return $this$hasChannel.isPowered() && $this$hasChannel.isActive();
    }

    @NotNull
    public static final P2PInfo getInfo(@NotNull PartP2PTunnel<?> $this$getInfo, int index) {
        Intrinsics.checkParameterIsNotNull($this$getInfo, (String)"$this$getInfo");
        short s = $this$getInfo.getFrequency();
        DimensionalCoord dimensionalCoord = $this$getInfo.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionalCoord, (String)"location");
        BlockPos blockPos = dimensionalCoord.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"location.pos");
        AEPartLocation aEPartLocation = $this$getInfo.getSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)aEPartLocation, (String)"side");
        EnumFacing enumFacing = aEPartLocation.getFacing();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"side.facing");
        return new P2PInfo(index, s, blockPos, enumFacing, $this$getInfo.isOutput(), P2PUtilKt.getHasChannel($this$getInfo));
    }
}

