/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.misc;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class Weakness {
    private final Set<ResourceLocation> cache = Sets.newHashSet();
    private final Predicate<EntityLivingBase> predicate;

    private Weakness(Predicate<EntityLivingBase> predicate) {
        this.predicate = predicate;
    }

    public static Weakness create(Predicate<EntityLivingBase> predicate, String ... ids) {
        return new Weakness(predicate).register(ids);
    }

    public Weakness register(String ... ids) {
        Arrays.stream(ids).forEach(this::register);
        return this;
    }

    public Weakness register(String id) {
        if (!id.isEmpty()) {
            this.cache.add(new ResourceLocation(id));
        }
        return this;
    }

    public boolean contains(EntityLivingBase entity) {
        return this.get(entity) > 1.0f;
    }

    public float get(EntityLivingBase entity) {
        float weakness = 1.0f;
        if (entity != null && (this.cache.contains(EntityList.func_191301_a((Entity)entity)) || this.predicate.test(entity))) {
            weakness = 1.5f;
            if (entity instanceof EntityPlayer) {
                weakness *= 1.5f;
            }
        }
        return weakness;
    }
}

