/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.Bewitchment;
import com.bewitchment.common.block.tile.entity.TileEntityBrazier;
import com.bewitchment.common.block.util.ModBlockContainer;
import com.bewitchment.common.item.ItemTaglock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBrazier
extends ModBlockContainer {
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockBrazier() {
        super(Bewitchment.instance, "brazier", Material.field_151573_f, SoundType.field_185851_d, 5.0f, 30.0f, "pickaxe", -1);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBrazier();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= (Boolean)state.func_177229_b((IProperty)HANGING) != false ? 1 : 0;
        return meta |= (Boolean)state.func_177229_b((IProperty)LIT) != false ? 2 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue() && rand.nextDouble() < 0.33) {
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() / 4.0, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() / 4.0, 0.0, 0.01, 0.0, new int[0]);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HANGING, LIT});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase living, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(face == EnumFacing.DOWN));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityBrazier tile;
        if (world.func_175625_s(pos) instanceof TileEntityBrazier && (tile = (TileEntityBrazier)world.func_175625_s(pos)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_77973_b() instanceof ItemTaglock || stack.func_77973_b().func_77668_q() != null) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        TileEntityBrazier te = (TileEntityBrazier)world.func_175625_s(pos);
        return te.activate(world, pos, player, hand, face);
    }
}

