/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.item.equipment.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.render.IRenderBauble;
import com.bewitchment.Util;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.client.model.bauble.ModelGirdleOfTheDryad;
import com.bewitchment.client.model.bauble.ModelGirdleOfTheDryadArmor;
import com.bewitchment.common.item.util.ModItemBauble;
import com.bewitchment.registry.ModObjects;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGirdleOfTheDryads
extends ModItemBauble
implements IRenderBauble {
    public ItemGirdleOfTheDryads() {
        super("girdle_of_the_dryads", BaubleType.BELT);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_77777_bU = 1;
    }

    public static ItemStack getGirdle(EntityLivingBase living) {
        if (Util.hasBauble(living, ModObjects.girdle_of_the_dryads)) {
            EntityPlayer player = (EntityPlayer)living;
            for (int i = 0; i < BaublesApi.getBaublesHandler((EntityPlayer)player).getSlots(); ++i) {
                ItemStack bauble = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i);
                if (bauble.func_77973_b() != ModObjects.girdle_of_the_dryads) continue;
                return bauble;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static int getBark(EntityLivingBase living) {
        ItemStack stack;
        if (Util.hasBauble(living, ModObjects.girdle_of_the_dryads) && !(stack = ItemGirdleOfTheDryads.getGirdle(living)).func_190926_b()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            return stack.func_77978_p().func_74762_e("bark");
        }
        return -1;
    }

    public static void setBark(ItemStack stack, int amount) {
        if (!stack.func_190926_b()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("bark", amount);
        }
    }

    public void onWornTick(ItemStack stack, EntityLivingBase living) {
        if (!living.field_70170_p.field_72995_K && living.func_70681_au().nextDouble() < 8.0E-4 && living.field_70170_p.func_180495_p(living.func_180425_c().func_177977_b()).func_177230_c() instanceof BlockGrass && ItemGirdleOfTheDryads.getBark(living) > -1 && ItemGirdleOfTheDryads.getBark(living) < 4 && living instanceof EntityPlayer && MagicPower.attemptDrain(null, (EntityPlayer)living, 20)) {
            living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 10, false, false));
            living.field_70170_p.func_184133_a(null, living.func_180425_c(), SoundEvents.field_187542_ac, SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemGirdleOfTheDryads.setBark(ItemGirdleOfTheDryads.getGirdle(living), ItemGirdleOfTheDryads.getBark(living) + 1);
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase living) {
        living.func_184185_a(SoundEvents.field_187897_gY, 0.75f, 1.9f);
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase living) {
        ItemGirdleOfTheDryads.setBark(stack, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer living, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            ModelGirdleOfTheDryad model = living.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() ? new ModelGirdleOfTheDryad() : new ModelGirdleOfTheDryadArmor();
            GlStateManager.func_179094_E();
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)living);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.02);
            GlStateManager.func_179139_a((double)0.12, (double)0.12, (double)0.12);
            IRenderBauble.Helper.translateToChest();
            IRenderBauble.Helper.defaultTransforms();
            model.func_78088_a((Entity)living, living.field_184619_aG, living.field_70721_aZ, living.field_70173_aa, living.field_70126_B, living.field_70125_A, 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && ItemGirdleOfTheDryads.getBark(event.getEntityLiving()) > 0) {
            if (event.getSource().func_76347_k()) {
                event.setAmount(event.getAmount() * 1.25f);
                ItemGirdleOfTheDryads.setBark(ItemGirdleOfTheDryads.getGirdle(event.getEntityLiving()), ItemGirdleOfTheDryads.getBark(event.getEntityLiving()) - 1);
            }
            if (!event.getSource().func_82725_o() && event.getSource().func_76346_g() != null && event.getAmount() > 2.0f) {
                event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), SoundEvents.field_187897_gY, SoundCategory.PLAYERS, 0.75f, 1.9f);
                ItemGirdleOfTheDryads.setBark(ItemGirdleOfTheDryads.getGirdle(event.getEntityLiving()), ItemGirdleOfTheDryads.getBark(event.getEntityLiving()) - 1);
                event.setCanceled(true);
            }
        }
    }
}

