/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.integration.IntegrationBase;
import mod.chiselsandbits.integration.mcmultipart.IMCMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MCMultipartProxy
extends IntegrationBase {
    public static final MCMultipartProxy proxyMCMultiPart = new MCMultipartProxy();
    protected IMCMultiPart relay = new MCMultiPartNullRelay();

    protected void setRelay(IMCMultiPart mcMultiPart) {
        this.relay = mcMultiPart;
    }

    public TileEntityBlockChiseled getChiseledTileEntity(World world, BlockPos pos, boolean create) {
        return this.relay.getPartIfPossible(world, pos, create);
    }

    public void removeChisledBlock(TileEntity te) {
        this.relay.removePartIfPossible(te);
    }

    public boolean isMultiPartTileEntity(World w, BlockPos pos) {
        return this.relay.isMultiPart(w, pos);
    }

    public void convertTo(TileEntity current, TileEntityBlockChiseled newTileEntity) {
        this.relay.swapRenderIfPossible(current, newTileEntity);
    }

    public void triggerPartChange(TileEntity te) {
        this.relay.triggerPartChange(te);
    }

    public void addFiller(World w, BlockPos pos, VoxelBlob vb) {
        this.relay.populateBlobWithUsedSpace(w, pos, vb);
    }

    public boolean rotate(World world, BlockPos pos, EntityPlayer player) {
        return this.relay.rotate(world, pos, player);
    }

    public TileEntityBlockChiseled getPartFromBlockAccess(IBlockAccess world, BlockPos pos) {
        return this.relay.getPartFromBlockAccess(world, pos);
    }

    private static class MCMultiPartNullRelay
    implements IMCMultiPart {
        private MCMultiPartNullRelay() {
        }

        @Override
        public void swapRenderIfPossible(TileEntity current, TileEntityBlockChiseled newTileEntity) {
        }

        @Override
        public void removePartIfPossible(TileEntity te) {
        }

        @Override
        public TileEntityBlockChiseled getPartIfPossible(World world, BlockPos pos, boolean create) {
            return null;
        }

        @Override
        public void triggerPartChange(TileEntity te) {
        }

        @Override
        public boolean isMultiPart(World w, BlockPos pos) {
            return false;
        }

        @Override
        public void populateBlobWithUsedSpace(World w, BlockPos pos, VoxelBlob vb) {
        }

        @Override
        public boolean rotate(World world, BlockPos pos, EntityPlayer player) {
            return false;
        }

        @Override
        public TileEntityBlockChiseled getPartFromBlockAccess(IBlockAccess w, BlockPos pos) {
            return null;
        }
    }
}

