/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderFurnace;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerEnderFurnace;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityEnderFurnace
extends TileEntityEnderUtilitiesInventory
implements ITickable {
    public static final int COOKTIME_INC_NOFUEL = 1;
    public static final int COOKTIME_INC_SLOW = 20;
    public static final int COOKTIME_INC_FAST = 60;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int OUTPUT_INTERVAL = 20;
    protected static final int[] SLOTS_SIDES = new int[]{0, 1, 2};
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    private final IItemHandler inventoryWrapperSmeltables;
    private final IItemHandler inventoryWrapperNonSmeltables;
    public boolean fastMode = false;
    public boolean outputToEnderChest = false;
    private ItemStack smeltingResultCache = ItemStack.field_190927_a;
    private boolean inputDirty = true;
    public int burnTimeRemaining = 0;
    public int burnTimeFresh;
    public int cookTime = 0;
    public boolean isBurningLast;
    public boolean isCookingLast;
    private int timer = 0;

    public TileEntityEnderFurnace() {
        super("ender_furnace");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 3, 1024, true, "Items", this);
        this.inventoryWrapperSmeltables = new ItemHandlerWrapperEnderFurnaceSmeltables(this.getBaseItemHandler(), this);
        this.inventoryWrapperNonSmeltables = new ItemHandlerWrapperEnderFurnaceNonSmeltables(this.getBaseItemHandler(), this);
        this.itemHandlerExternal = new ItemHandlerWrapperEnderFurnace(this.getBaseItemHandler(), this);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte flags = nbt.func_74771_c("Flags");
        this.fastMode = (flags & 1) == 1;
        this.outputToEnderChest = (flags & 2) == 2;
        this.burnTimeRemaining = nbt.func_74762_e("BurnTimeRemaining");
        this.burnTimeFresh = nbt.func_74762_e("BurnTimeFresh");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.inputDirty = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        byte flags = 0;
        if (this.fastMode) {
            flags = (byte)(flags | 1);
        }
        if (this.outputToEnderChest) {
            flags = (byte)(flags | 2);
        }
        nbt.func_74774_a("Flags", flags);
        nbt.func_74777_a("BurnTimeRemaining", (short)this.burnTimeRemaining);
        nbt.func_74777_a("BurnTimeFresh", (short)this.burnTimeFresh);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        byte flags = 0;
        if (this.canSmelt()) {
            flags = (byte)(flags | 0x10);
        }
        if (this.isBurning()) {
            flags = (byte)(flags | 0x20);
        }
        if (this.fastMode) {
            flags = (byte)(flags | 0x40);
        }
        nbt.func_74774_a("f", flags);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        byte flags = tag.func_74771_c("f");
        this.isCookingLast = (flags & 0x10) == 16;
        this.isBurningLast = (flags & 0x20) == 32;
        this.fastMode = (flags & 0x40) == 64;
        super.handleUpdateTag(tag);
        this.func_145831_w().func_175664_x(this.func_174877_v());
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    private void updateSmeltingResult() {
        if (this.inputDirty) {
            this.smeltingResultCache = !this.getBaseItemHandler().getStackInSlot(0).func_190926_b() ? FurnaceRecipes.func_77602_a().func_151395_a(this.getBaseItemHandler().getStackInSlot(0)) : ItemStack.field_190927_a;
            this.inputDirty = false;
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.updateSmeltingResult();
        boolean dirty = false;
        boolean canSmelt = this.canSmelt();
        boolean hasFuel = this.hasFuelAvailable();
        int cookTimeIncrement = 20;
        if (this.burnTimeRemaining == 0 && !hasFuel) {
            cookTimeIncrement = 1;
        } else if (this.fastMode) {
            cookTimeIncrement = 60;
        }
        if (this.burnTimeRemaining > 0) {
            int btUse;
            int n = btUse = this.fastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining) {
                if (hasFuel && canSmelt) {
                    this.burnTimeRemaining += this.consumeFuelItem();
                    hasFuel = this.hasFuelAvailable();
                } else {
                    cookTimeIncrement = this.burnTimeRemaining * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining;
                }
            }
            this.burnTimeRemaining -= btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            this.burnTimeRemaining += this.consumeFuelItem();
            hasFuel = this.hasFuelAvailable();
            dirty = true;
        }
        if (canSmelt) {
            this.cookTime += cookTimeIncrement;
            if (this.cookTime >= 1200) {
                this.smeltItem();
                canSmelt = this.canSmelt();
                this.cookTime = canSmelt && this.cookTime > 1200 ? (this.cookTime -= 1200) : 0;
            }
            if (this.burnTimeRemaining == 0 && hasFuel && canSmelt) {
                this.burnTimeRemaining += this.consumeFuelItem();
            }
            dirty = true;
        } else if (this.cookTime > 0) {
            this.cookTime -= Math.min(this.cookTime, 10);
            dirty = true;
        }
        if (this.outputToEnderChest && !this.getBaseItemHandler().getStackInSlot(2).func_190926_b() && ++this.timer >= 20) {
            if (this.moveItemsToEnderChest()) {
                dirty = true;
            }
            this.timer = 0;
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (this.isBurningLast != this.isBurning() || this.isCookingLast != canSmelt) {
            this.notifyBlockUpdate(this.func_174877_v());
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
        this.isBurningLast = this.isBurning();
        this.isCookingLast = canSmelt;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            this.getBaseItemHandler().insertItem(2, this.smeltingResultCache.func_77946_l(), false);
            this.getBaseItemHandler().extractItem(0, 1, false);
            if (this.getBaseItemHandler().getStackInSlot(0).func_190926_b()) {
                this.inputDirty = true;
            }
        }
    }

    private int consumeFuelItem() {
        int burnTime = TileEntityEnderFurnace.consumeFuelItem(this.getBaseItemHandler(), 1, false);
        if (burnTime > 0) {
            this.burnTimeFresh = burnTime;
        }
        return burnTime;
    }

    public static int consumeFuelItem(IItemHandler fuelInv, int fuelSlot, boolean simulate) {
        ItemStack stack = fuelInv.getStackInSlot(fuelSlot);
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = 0;
        if (TileEntityEnderFurnace.itemContainsFluidFuel(stack)) {
            if (stack.func_190916_E() > 1) {
                return 0;
            }
            stack = fuelInv.extractItem(fuelSlot, 1, simulate);
            burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(stack);
        } else {
            burnTime = TileEntityEnderFurnace.getItemBurnTime(stack);
            if (burnTime == 0 || stack.func_190916_E() > 1 && !stack.func_77973_b().getContainerItem(stack).func_190926_b()) {
                return 0;
            }
            stack = fuelInv.extractItem(fuelSlot, 1, simulate);
            stack = stack.func_77973_b().getContainerItem(stack);
        }
        if (!simulate && !stack.func_190926_b()) {
            fuelInv.insertItem(fuelSlot, stack, false);
        }
        return burnTime;
    }

    private boolean moveItemsToEnderChest() {
        if (this.getBaseItemHandler().getStackInSlot(2).func_190926_b() || this.ownerData == null || this.ownerData.getOwnerUUID() == null) {
            return false;
        }
        EntityPlayer player = this.func_145831_w().func_152378_a(this.ownerData.getOwnerUUID());
        if (player == null) {
            return false;
        }
        ItemStack stack = this.getBaseItemHandler().extractItem(2, 64, false);
        if (stack.func_190926_b()) {
            return false;
        }
        int origSize = stack.func_190916_E();
        InvWrapper inv = new InvWrapper((IInventory)player.func_71005_bN());
        stack = InventoryUtils.tryInsertItemStackToInventory((IItemHandler)inv, stack);
        if (stack.func_190926_b()) {
            return true;
        }
        boolean movedItems = origSize != stack.func_190916_E();
        this.getBaseItemHandler().insertItem(2, stack, false);
        return movedItems;
    }

    private boolean hasFuelAvailable() {
        return TileEntityEnderFurnace.consumeFuelItem(this.getBaseItemHandler(), 1, true) > 0;
    }

    public boolean canSmelt() {
        if (this.getBaseItemHandler().getStackInSlot(0).func_190926_b() || this.smeltingResultCache.func_190926_b()) {
            return false;
        }
        return this.getBaseItemHandler().insertItem(2, this.smeltingResultCache, true).func_190926_b();
    }

    private static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack) * 1200 * 3 / 400;
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 2700;
            }
            if (block == Blocks.field_150402_ci) {
                return 144000;
            }
            if (block == Blocks.field_150376_bx) {
                return 1350;
            }
            if (block == Blocks.field_150345_g) {
                return 900;
            }
        } else {
            if (item == Items.field_151044_h) {
                return 14400;
            }
            if (item == Items.field_151072_bj) {
                return 21600;
            }
            if (item == Items.field_151129_at) {
                return 180000;
            }
            if (item == Items.field_151055_y) {
                return 900;
            }
            if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
                return 1800;
            }
            if (item == Items.field_151065_br) {
                return 10800;
            }
            if (item == Items.field_151079_bi) {
                return 9600;
            }
            if (item == Items.field_151061_bv) {
                return 20400;
            }
        }
        return 0;
    }

    private static int consumeFluidFuelDosage(ItemStack stack) {
        if (!TileEntityEnderFurnace.itemContainsFluidFuel(stack)) {
            return 0;
        }
        IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        FluidStack fluidStack = handler.drain(new FluidStack(FluidRegistry.LAVA, 1000), true);
        return fluidStack != null ? fluidStack.amount * 15 * 1200 / 100 : 0;
    }

    private static boolean itemContainsFluidFuel(ItemStack stack) {
        if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        FluidStack fluidStack = handler.drain(1000, false);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        return fluidStack.getFluid() == FluidRegistry.LAVA;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityEnderFurnace.itemContainsFluidFuel(stack) || TileEntityEnderFurnace.getItemBurnTime(stack) > 0;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryWrapperSmeltables);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryWrapperNonSmeltables);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (slot == 0) {
            this.inputDirty = true;
        }
    }

    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 1200;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTimeFresh == 0) {
            return 0;
        }
        return this.burnTimeRemaining * i / this.burnTimeFresh;
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0) {
            this.fastMode = !this.fastMode;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        } else if (action == 1) {
            this.outputToEnderChest = !this.outputToEnderChest;
        }
        this.func_70296_d();
    }

    @Override
    public ContainerEnderFurnace getContainer(EntityPlayer player) {
        return new ContainerEnderFurnace(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiEnderFurnace(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperEnderFurnaceSmeltables
    extends ItemHandlerWrapperSelective {
        public ItemHandlerWrapperEnderFurnaceSmeltables(IItemHandler baseHandler, TileEntityEnderFurnace te) {
            super(baseHandler);
        }

        @Override
        public int getSlots() {
            return 1;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
        }

        @Override
        public boolean canExtractFromSlot(int slot) {
            return false;
        }
    }

    private class ItemHandlerWrapperEnderFurnaceNonSmeltables
    extends ItemHandlerWrapperSelective {
        private final TileEntityEnderFurnace teef;

        public ItemHandlerWrapperEnderFurnaceNonSmeltables(IItemHandler baseHandler, TileEntityEnderFurnace te) {
            super(baseHandler);
            this.teef = te;
        }

        @Override
        public int getSlots() {
            return 2;
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return super.getStackInSlot(slot + 1);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.isItemValidForSlot(slot, stack)) {
                return this.baseHandler.insertItem(slot + 1, stack, simulate);
            }
            return stack;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.canExtractFromSlot(slot)) {
                return this.baseHandler.extractItem(slot + 1, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            return slot == 0 && TileEntityEnderFurnace.isItemFuel(stack);
        }

        @Override
        public boolean canExtractFromSlot(int slot) {
            return slot == 0 && !TileEntityEnderFurnace.isItemFuel(this.getStackInSlot(slot)) || slot == 1 && !this.teef.outputToEnderChest;
        }
    }

    private class ItemHandlerWrapperEnderFurnace
    extends ItemHandlerWrapperSelective {
        private final TileEntityEnderFurnace teef;

        public ItemHandlerWrapperEnderFurnace(IItemHandler baseHandler, TileEntityEnderFurnace te) {
            super(baseHandler);
            this.teef = te;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (slot == 0) {
                return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
            }
            return slot == 1 && TileEntityEnderFurnace.isItemFuel(stack);
        }

        @Override
        public boolean canExtractFromSlot(int slot) {
            return slot == 1 && !TileEntityEnderFurnace.isItemFuel(this.getStackInSlot(slot)) || slot == 2 && !this.teef.outputToEnderChest;
        }
    }
}

