/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.api.recipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.api.util.StackHelper;

public class LightningCrusherRecipe {
    private Object in;
    private List<ItemStack> excluding;
    private List<ItemStack> inCache;
    private ItemStack out;

    public LightningCrusherRecipe(ItemStack out, Object in, ItemStack ... excluding) {
        if (!(in instanceof List || in instanceof ItemStack || in instanceof String)) {
            throw new IllegalArgumentException("Crusher recipe input invalid.");
        }
        this.in = in;
        this.excluding = new JointList<ItemStack>();
        if (excluding != null) {
            for (ItemStack s : excluding) {
                this.excluding.add(s.func_77946_l());
            }
        }
        this.inCache = null;
        this.out = out;
    }

    public Object getInputRaw() {
        return this.in;
    }

    public List<ItemStack> getInputBase() {
        if (this.in instanceof List) {
            return (List)this.in;
        }
        if (this.in instanceof ItemStack) {
            return new JointList<Object>().join(((ItemStack)this.in).func_77946_l());
        }
        if (OreDictionary.doesOreNameExist((String)((String)this.in))) {
            return OreDictionary.getOres((String)((String)this.in));
        }
        return new JointList<ItemStack>();
    }

    public List<ItemStack> getInput() {
        if (this.inCache == null) {
            ArrayList<ItemStack> base = new ArrayList<ItemStack>(this.getInputBase());
            for (ItemStack ex : this.excluding) {
                Iterator iterator = base.iterator();
                while (iterator.hasNext()) {
                    ItemStack in = (ItemStack)iterator.next();
                    if (!StackHelper.areItemStacksEqualForCrafting(in, ex)) continue;
                    iterator.remove();
                }
            }
            this.inCache = base;
            return this.inCache;
        }
        return this.inCache;
    }

    public ItemStack getOutput() {
        return this.out.func_77946_l();
    }

    public List<ItemStack> getExcluding() {
        return this.excluding;
    }
}

