/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.api.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    private static Map<String, Integer> oreMap = new HashMap<String, Integer>();
    private static Map<String, Integer> subMap = new HashMap<String, Integer>();
    public static Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public static ItemStack animateItemStackFromString(String stackString, boolean change) {
        ItemStack result;
        ItemStack primary;
        int ores = OreDictionary.doesOreNameExist((String)stackString) ? OreDictionary.getOres((String)stackString).size() : 1;
        int oreIndex = 0;
        int subIndex = 0;
        if (oreMap.containsKey(stackString)) {
            oreIndex = oreMap.get(stackString);
        }
        if (change) {
            oreIndex = ores > 0 ? rand.nextInt(ores) : 0;
            oreMap.put(stackString, oreIndex);
        }
        if ((primary = StackHelper.makeItemStackFromString(stackString, oreIndex)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NonNullList subItems = NonNullList.func_191196_a();
        primary.func_77973_b().func_150895_a(null, subItems);
        if (subMap.containsKey(stackString)) {
            subIndex = subMap.get(stackString);
        }
        if (primary.func_77952_i() == Short.MAX_VALUE && !subItems.isEmpty()) {
            if (change) {
                subIndex = rand.nextInt(subItems.size());
                subMap.put(stackString, subIndex);
            }
            result = (ItemStack)subItems.get(subIndex);
        } else {
            result = primary;
        }
        return result;
    }

    private static boolean isStringOreDict(String stackString) {
        if (stackString == "NULL") {
            return false;
        }
        return OreDictionary.doesOreNameExist((String)stackString);
    }

    @Nonnull
    public static ItemStack makeItemStackFromString(String stackString, int oreIndex) {
        if (stackString == "NULL") {
            return ItemStack.field_190927_a;
        }
        try {
            if (!StackHelper.isStringOreDict(stackString)) {
                return new ItemStack(JsonToNBT.func_180713_a((String)stackString));
            }
            throw new NBTException("OreDict exists", "", 0);
        }
        catch (NBTException e) {
            NonNullList list;
            if (StackHelper.isStringOreDict(stackString) && oreIndex < (list = OreDictionary.getOres((String)stackString)).size()) {
                return (ItemStack)list.get(oreIndex);
            }
            return ItemStack.field_190927_a;
        }
    }

    @Nonnull
    public static ItemStack makeItemStackFromString(String stackString) {
        return StackHelper.makeItemStackFromString(stackString, 0);
    }

    public static int getMetaFromString(String stackString) {
        if (!StackHelper.isStringOreDict(stackString)) {
            ItemStack stack = StackHelper.makeItemStackFromString(stackString);
            return !stack.func_190926_b() ? stack.func_77952_i() : 0;
        }
        return -1;
    }

    public static String changeStringMeta(String stackString, int newMeta) {
        try {
            if (!StackHelper.isStringOreDict(stackString)) {
                ItemStack stack = StackHelper.makeItemStackFromString(stackString);
                stack.func_77964_b(newMeta);
                return StackHelper.makeStringFromItemStack(stack);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return stackString;
    }

    public static String changeStringNBT(String stackString, NBTTagCompound newTag) {
        try {
            if (!StackHelper.isStringOreDict(stackString)) {
                ItemStack stack = StackHelper.makeItemStackFromString(stackString);
                stack.func_77982_d(newTag);
                return StackHelper.makeStringFromItemStack(stack);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return stackString;
    }

    public static String stripMetaFromString(String stackString) {
        return StackHelper.changeStringMeta(stackString, 0);
    }

    public static String stripNBTFromString(String stackString) {
        return StackHelper.changeStringNBT(stackString, null);
    }

    public static String makeStringFromItemStack(@Nonnull Object stack) {
        if (stack instanceof ItemStack) {
            ItemStack s = (ItemStack)stack;
            return s.func_77955_b(new NBTTagCompound()).toString();
        }
        if (stack instanceof String) {
            return (String)stack;
        }
        throw new IllegalArgumentException("Parameter must be a String or an ItemStack, was given " + stack.getClass());
    }

    public static boolean areItemStacksEqualForCrafting(ItemStack ... stacks) {
        ItemStack comp = stacks[0];
        if (comp.func_190926_b()) {
            return false;
        }
        ItemStack comp1 = comp.func_77946_l();
        comp1.func_190920_e(1);
        for (int n = 1; n < stacks.length; ++n) {
            if (stacks[n].func_190926_b()) {
                return false;
            }
            ItemStack comp2 = stacks[n].func_77946_l();
            comp2.func_190920_e(1);
            if (ItemStack.func_77989_b((ItemStack)comp1, (ItemStack)comp2)) continue;
            if (comp1.func_77952_i() == Short.MAX_VALUE) {
                comp2.func_77964_b(Short.MAX_VALUE);
                if (ItemStack.func_77989_b((ItemStack)comp1, (ItemStack)comp2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean setStackColor(@Nonnull ItemStack stack, Color color) {
        if (!(stack.func_77973_b() instanceof ItemArmor)) {
            return false;
        }
        Item armor = stack.func_77973_b();
        if (armor != Items.field_151021_T && armor != Items.field_151026_S && armor != Items.field_151027_R && armor != Items.field_151024_Q) {
            return false;
        }
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
        }
        NBTTagCompound disp = new NBTTagCompound();
        disp.func_74768_a("color", color.getRGB());
        nbttagcompound.func_74782_a("display", (NBTBase)disp);
        stack.func_77982_d(nbttagcompound);
        return true;
    }

    public static List<NBTTagCompound> getEnchantments(@Nonnull ItemStack s) {
        ArrayList<NBTTagCompound> enchList = new ArrayList<NBTTagCompound>();
        if (!s.func_190926_b() && s.func_77942_o()) {
            String ench = s.func_77973_b() == Items.field_151134_bR ? "StoredEnchantments" : "ench";
            NBTTagList enchants = (NBTTagList)s.func_77978_p().func_74781_a(ench);
            if (enchants != null && enchants.func_74745_c() > 0) {
                for (int i = 0; i < enchants.func_74745_c(); ++i) {
                    NBTTagCompound enchant = enchants.func_150305_b(i);
                    enchList.add(enchant);
                }
            }
        }
        return enchList;
    }

    public static boolean addEnchantments(@Nonnull ItemStack s, List<NBTTagCompound> enchList) {
        if (!s.func_190926_b()) {
            NBTTagList currentEnchants;
            String ench;
            String string = ench = s.func_77973_b() == Items.field_151134_bR ? "StoredEnchantments" : "ench";
            if (!s.func_77942_o()) {
                s.func_77982_d(new NBTTagCompound());
            }
            if ((currentEnchants = (NBTTagList)s.func_77978_p().func_74781_a(ench)) == null) {
                currentEnchants = new NBTTagList();
            }
            for (int i = 0; i < enchList.size(); ++i) {
                currentEnchants.func_74742_a((NBTBase)enchList.get(i));
            }
            s.func_77978_p().func_74782_a(ench, (NBTBase)currentEnchants);
            return true;
        }
        return false;
    }

    public static boolean oreDictNameStartsWith(@Nonnull ItemStack ore, String start) {
        for (int i : OreDictionary.getOreIDs((ItemStack)ore)) {
            if (!OreDictionary.getOreName((int)i).startsWith(start)) continue;
            return false;
        }
        return false;
    }

    public static boolean logOre(@Nonnull ItemStack ore) {
        OreDictionary.getOreIDs((ItemStack)ore);
        return true;
    }

    public static boolean oreDictNameEquals(@Nonnull ItemStack ore, String equals) {
        for (int i : OreDictionary.getOreIDs((ItemStack)ore)) {
            if (!OreDictionary.getOreName((int)i).equals(equals)) continue;
            return true;
        }
        return false;
    }

    public static int[] makeIntArray(@Nonnull ItemStack[] stacks) {
        return StackHelper.makeIntArray(stacks.length);
    }

    public static int[] makeIntArray(int size) {
        int[] ints = new int[size];
        for (int i = 0; i < size; ++i) {
            ints[i] = i;
        }
        return ints;
    }
}

