/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.init.LCItems;

public class LightningTransformRecipes {
    private static LightningTransformRecipes instance = new LightningTransformRecipes();
    private Map<List<ItemStack>, ItemStack> recipeList;

    public static LightningTransformRecipes instance() {
        return instance;
    }

    public LightningTransformRecipes() {
        this.addDefaultRecipes();
    }

    private void addDefaultRecipes() {
        this.recipeList = new HashMap<List<ItemStack>, ItemStack>();
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 1, 0), new JointList<Object>().join(new ItemStack(Items.field_151042_j)).join((Object[])new Object[]{new ItemStack(Items.field_151043_k)}).join((Object[])new Object[]{new ItemStack(Items.field_151045_i)}));
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 11), new JointList<Object>().join(new ItemStack(Items.field_151166_bC)).join((Object[])new Object[]{new ItemStack((Item)LCItems.ingot, 1, 1)}).join((Object[])new Object[]{new ItemStack((Item)LCItems.material, 1, 5)}));
        this.addRecipe(new ItemStack((Item)LCItems.guide), new JointList<Object>().join(new ItemStack(Items.field_151122_aG)));
    }

    public void addRecipe(@Nonnull ItemStack output, List<ItemStack> input) {
        this.recipeList.put(input, output);
    }

    @Nonnull
    public ItemStack getTransformResult(List<ItemStack> input) {
        int matches = 0;
        List<ItemStack> comp = null;
        ItemStack result = ItemStack.field_190927_a;
        for (Map.Entry<List<ItemStack>, ItemStack> entry : this.recipeList.entrySet()) {
            for (ItemStack rIn : entry.getKey()) {
                for (ItemStack iIn : input) {
                    if (!ItemStack.func_77989_b((ItemStack)rIn, (ItemStack)iIn)) continue;
                    ++matches;
                    result = entry.getValue();
                    comp = entry.getKey();
                }
            }
        }
        if (matches == input.size() && matches == comp.size()) {
            return result.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public Map<List<ItemStack>, ItemStack> getRecipeList() {
        return this.recipeList;
    }
}

