/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.IFurnace;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;

public class TileEntityLightningFurnace
extends TileEntityLightningItemHandler.Upgradable {
    private static final int top = 0;
    private static final int bottom = 1;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private static final int[] slotsSides = new int[]{0};
    private static final int burnTime = 80;
    public int furnaceBurnTime;
    public int furnaceCookTime;
    public int currentBurnTime;
    private boolean redo;

    public TileEntityLightningFurnace() {
        this.setSizeInventory(2);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 40;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 40;
        }
        return this.furnaceBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.furnaceBurnTime > 0;
        boolean dosave = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.furnaceBurnTime = 80;
                this.currentBurnTime = 80;
                if (this.furnaceBurnTime > 0) {
                    dosave = true;
                    this.drawCellPower(1.0);
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 40) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    dosave = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (burning != this.furnaceBurnTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.furnaceBurnTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
        if (this.isUpgraded() && !this.redo) {
            this.redo = true;
            this.func_73660_a();
        }
        this.redo = false;
    }

    private boolean canSmelt() {
        if (!this.hasLPCell() || !this.canDrawCellPower(1.0)) {
            return false;
        }
        if (this.getStack(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.getStack(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (this.getStack(1).func_190926_b()) {
            return true;
        }
        if (!this.getStack(1).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.getStack(1).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.getStack(1).func_77976_d();
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.getStack(0));
            if (this.getStack(1).func_190926_b()) {
                this.setStack(1, itemstack.func_77946_l());
            } else if (this.getStack(1).func_77973_b() == itemstack.func_77973_b()) {
                this.getStack(1).func_190920_e(this.getStack(1).func_190916_E() + itemstack.func_190916_E());
            }
            this.getStack(0).func_190920_e(this.getStack(0).func_190916_E() - 1);
            if (this.getStack(0).func_190916_E() <= 0) {
                this.setStack(0, ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 1;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return facing == EnumFacing.UP ? slotsTop : (facing == EnumFacing.DOWN ? slotsBottom : slotsSides);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return slot == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 80;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.furnaceBurnTime);
        return tagCompound;
    }
}

