/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeRuneAltar;

@ZenClass(value="mods.botania.RuneAltar")
@ModOnly(value="botania")
@ZenRegister
public class RuneAltar {
    protected static final String name = "Botania Rune Altar";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input, int mana) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new RecipeRuneAltar(InputHelper.toStack((IItemStack)output), mana, InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    private static class Remove
    extends BaseListRemoval<RecipeRuneAltar> {
        final IIngredient output;

        public Remove(IIngredient output) {
            super(RuneAltar.name, BotaniaAPI.runeAltarRecipes);
            this.output = output;
        }

        public String getRecipeInfo(RecipeRuneAltar recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }

        public void apply() {
            LinkedList<RecipeRuneAltar> recipes = new LinkedList<RecipeRuneAltar>();
            for (RecipeRuneAltar r : BotaniaAPI.runeAltarRecipes) {
                if (r == null || r.getOutput() == null || !StackHelper.matches((IIngredient)this.output, (IItemStack)InputHelper.toIItemStack((ItemStack)r.getOutput()))) continue;
                recipes.add(r);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            } else {
                LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", RuneAltar.name, this.output.toString()));
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        public String describe() {
            return "Attempting to remove Rune Altar recipe for " + this.output.getItems();
        }
    }

    private static class Add
    extends BaseListAddition<RecipeRuneAltar> {
        public Add(RecipeRuneAltar recipe) {
            super(RuneAltar.name, BotaniaAPI.runeAltarRecipes, Collections.singletonList(recipe));
        }

        public String getRecipeInfo(RecipeRuneAltar recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }
}

