/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles.base;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="gregtech.api.capability.IEnergyContainer", modid="gregtech")
public class GTEnergyContainer
implements IEnergyContainer {
    private final TileEnergyHatch hatch;
    private final MachineComponent.IOType ioType;

    public GTEnergyContainer(TileEnergyHatch hatch, MachineComponent.IOType ioType) {
        this.hatch = hatch;
        this.ioType = ioType;
    }

    @Optional.Method(modid="gregtech")
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (this.ioType == MachineComponent.IOType.INPUT && amperage > 0L && voltage > 0L) {
            long acceptingAmperage;
            long availableSpace = this.hatch.getMaxEnergy() / 4L - this.hatch.getCurrentEnergy() / 4L;
            long maxAmperage = Math.min(this.getInputAmperage(), amperage);
            if (voltage > this.getInputVoltage()) {
                if (ConfigHolder.doExplosions) {
                    BlockPos pos = this.hatch.func_174877_v();
                    this.hatch.func_145831_w().func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (float)GTUtility.getTierByVoltage((long)voltage), true);
                }
                return maxAmperage;
            }
            if (availableSpace >= voltage && (acceptingAmperage = Math.min(availableSpace / voltage, maxAmperage)) > 0L) {
                this.hatch.setCurrentEnergy(this.hatch.getCurrentEnergy() + acceptingAmperage * voltage * 4L);
                this.hatch.markForUpdate();
                return acceptingAmperage;
            }
        }
        return 0L;
    }

    @Optional.Method(modid="gregtech")
    public boolean inputsEnergy(EnumFacing side) {
        return this.ioType == MachineComponent.IOType.INPUT;
    }

    @Optional.Method(modid="gregtech")
    public boolean outputsEnergy(EnumFacing side) {
        return this.ioType == MachineComponent.IOType.OUTPUT;
    }

    @Optional.Method(modid="gregtech")
    public long changeEnergy(long differenceAmount) {
        long newEnergyStored;
        long oldEnergyStored = this.hatch.getCurrentEnergy() / 4L;
        long maxCapacity = this.hatch.getMaxEnergy() / 4L;
        long l = newEnergyStored = maxCapacity - oldEnergyStored < differenceAmount ? maxCapacity : oldEnergyStored + differenceAmount;
        if (newEnergyStored < 0L) {
            newEnergyStored = 0L;
        }
        this.hatch.setCurrentEnergy(newEnergyStored * 4L);
        return newEnergyStored - oldEnergyStored;
    }

    @Optional.Method(modid="gregtech")
    public long getEnergyStored() {
        return this.hatch.getCurrentEnergy() / 4L;
    }

    @Optional.Method(modid="gregtech")
    public long getEnergyCapacity() {
        return this.hatch.getMaxEnergy() / 4L;
    }

    @Optional.Method(modid="gregtech")
    public long getOutputAmperage() {
        return this.ioType == MachineComponent.IOType.OUTPUT ? (long)this.hatch.getTier().getGtAmperage() : 0L;
    }

    @Optional.Method(modid="gregtech")
    public long getOutputVoltage() {
        return this.ioType == MachineComponent.IOType.OUTPUT ? this.hatch.getTier().getGTEnergyTransferVoltage() : 0L;
    }

    @Optional.Method(modid="gregtech")
    public long getInputAmperage() {
        return this.ioType == MachineComponent.IOType.INPUT ? (long)this.hatch.getTier().getGtAmperage() : 0L;
    }

    @Optional.Method(modid="gregtech")
    public long getInputVoltage() {
        return this.ioType == MachineComponent.IOType.INPUT ? this.hatch.getTier().getGTEnergyTransferVoltage() : 0L;
    }
}

