/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.tile;

import fr.frinn.modularmagic.common.tile.machinecomponent.MachineComponentAspectProvider;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class TileAspectProvider
extends TileJarFillable
implements MachineComponentTile {
    private int maxAmount = 250;

    public boolean canInputFrom(EnumFacing face) {
        return true;
    }

    public boolean canOutputTo(EnumFacing face) {
        return true;
    }

    public boolean isConnectable(EnumFacing face) {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.amount < this.maxAmount) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                this.fillJar(face);
            }
        }
    }

    void fillJar(EnumFacing face) {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(face.func_176734_d())) {
                return;
            }
            Aspect ta = null;
            if (this.aspect != null && this.amount > 0) {
                ta = this.aspect;
            } else if (ic.getEssentiaAmount(face.func_176734_d()) > 0 && ic.getSuctionAmount(face.func_176734_d()) < this.getSuctionAmount(face) && this.getSuctionAmount(face) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(face.func_176734_d());
            }
            if (ta != null && ic.getSuctionAmount(face.func_176734_d()) < this.getSuctionAmount(face)) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, face.func_176734_d()));
            }
        }
    }

    @Nullable
    public MachineComponent provideComponent() {
        return null;
    }

    public static class Output
    extends TileAspectProvider {
        @Override
        @Nullable
        public MachineComponent provideComponent() {
            return new MachineComponentAspectProvider(this, MachineComponent.IOType.OUTPUT);
        }
    }

    public static class Input
    extends TileAspectProvider {
        @Override
        @Nullable
        public MachineComponent provideComponent() {
            return new MachineComponentAspectProvider(this, MachineComponent.IOType.INPUT);
        }
    }
}

