/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.block;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticalworld.init.ModItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOakApple
extends BlockBase
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB[] gall_apple_NORTH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.0625), new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.125), new AxisAlignedBB(0.40625, 0.40625, 0.0, 0.59375, 0.59375, 0.125), new AxisAlignedBB(0.40625, 0.40625, 0.0, 0.59375, 0.59375, 0.1875)};
    protected static final AxisAlignedBB[] gall_apple_SOUTH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.4375, 0.9375, 0.5625, 0.5625, 1.0), new AxisAlignedBB(0.4375, 0.4375, 0.875, 0.5625, 0.5625, 1.0), new AxisAlignedBB(0.40625, 0.40625, 0.875, 0.59375, 0.59375, 1.0), new AxisAlignedBB(0.40625, 0.40625, 0.8125, 0.59375, 0.59375, 1.0)};
    protected static final AxisAlignedBB[] gall_apple_WEST_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.0625, 0.5625, 0.5625), new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.125, 0.5625, 0.5625), new AxisAlignedBB(0.0, 0.40625, 0.40625, 0.125, 0.59375, 0.59375), new AxisAlignedBB(0.0, 0.40625, 0.40625, 0.1875, 0.59375, 0.59375)};
    protected static final AxisAlignedBB[] gall_apple_EAST_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.9375, 0.4375, 0.4375, 1.0, 0.5625, 0.5625), new AxisAlignedBB(0.875, 0.4375, 0.4375, 1.0, 0.5625, 0.5625), new AxisAlignedBB(0.875, 0.40625, 0.40625, 1.0, 0.59375, 0.59375), new AxisAlignedBB(0.8125, 0.40625, 0.40625, 1.0, 0.59375, 0.59375)};

    public BlockOakApple(@Nonnull String name) {
        super(Material.field_151585_k, SoundType.field_185850_c, 0.0f, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.setItemBlock(null);
        this.field_149783_u = true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        } else {
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        return iblockstate.func_177230_c() == Blocks.field_150364_r && (iblockstate.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.OAK || iblockstate.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.DARK_OAK);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case SOUTH: {
                return gall_apple_SOUTH_AABB[i];
            }
            default: {
                return gall_apple_NORTH_AABB[i];
            }
            case WEST: {
                return gall_apple_WEST_AABB[i];
            }
            case EAST: 
        }
        return gall_apple_EAST_AABB[i];
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        }
    }

    private void dropBlock(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.func_176226_b(worldIn, pos, state, 0);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3) {
            return ModItems.gall_apple;
        }
        return Items.field_190931_a;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3) {
            return new ItemStack(ModItems.gall_apple);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((meta & 0xF) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)AGE) << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, AGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176733_a((double)placer.field_70177_z);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (!facing.func_176740_k().func_176722_c()) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
    }
}

