/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.PlayerUtil;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.traits.AbstractTrait;

public class AoASkillThresholdTrait
extends AbstractTrait {
    private static final EnumMap<Enums.Skills, Int2ObjectMap<AoASkillThresholdTrait>> traitsCache = new EnumMap(Enums.Skills.class);
    private final Enums.Skills skill;
    private final int minLevel;

    public static AoASkillThresholdTrait fetch(String skill, int minLevel) {
        return AoASkillThresholdTrait.fetch(Enums.Skills.valueOf((String)skill.toUpperCase(Locale.US)), minLevel);
    }

    public static AoASkillThresholdTrait fetch(Enums.Skills skill, int minLevel) {
        Int2ObjectMap lvToTrait = traitsCache.computeIfAbsent(skill, k -> new Int2ObjectOpenHashMap());
        if (!lvToTrait.containsKey(minLevel)) {
            lvToTrait.put(minLevel, (Object)new AoASkillThresholdTrait(skill, minLevel));
        }
        return (AoASkillThresholdTrait)((Object)lvToTrait.get(minLevel));
    }

    public AoASkillThresholdTrait(Enums.Skills skill, int minLevel, String customIdentifier) {
        super(customIdentifier, 0xFFFFFF);
        this.skill = skill;
        this.minLevel = minLevel;
    }

    public AoASkillThresholdTrait(Enums.Skills skill, int minLevel) {
        this(skill, minLevel, AoASkillThresholdTrait.genIdentifier(skill, minLevel));
    }

    public static String genIdentifier(Enums.Skills skill, int minLevel) {
        return "aoa_threshold_" + skill.name().toLowerCase(Locale.US) + "_" + minLevel;
    }

    public Enums.Skills getSkill() {
        return this.skill;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d && !PlayerUtil.doesPlayerHaveLevel((EntityPlayer)((EntityPlayer)entity), (Enums.Skills)this.getSkill(), (int)this.getMinLevel())) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)tool);
            player.func_184611_a(player.func_184592_cb() == tool ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            player.field_71069_bz.func_75142_b();
        }
    }

    public String getLocalizedName() {
        return Util.translateFormatted((String)"modifier.aoa_threshold.name", (Object[])new Object[]{Util.translate((String)"skills.%s.name", (Object[])new Object[]{this.getSkill().name().toLowerCase(Locale.US)}), this.getMinLevel()});
    }

    public String getLocalizedDesc() {
        return Util.translateFormatted((String)"modifier.aoa_threshold.desc", (Object[])new Object[]{Util.translate((String)"skills.%s.name", (Object[])new Object[]{this.getSkill().name().toLowerCase(Locale.US)}), this.getMinLevel()});
    }
}

