/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.builder;

import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderBlock;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderContainer;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class DimensionBuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_GETBUILDING = "getBuilding";
    public static final Key<Integer> PARAM_BUILDING_PROGRESS = new Key("buildingprogress", Type.INTEGER);
    public static final String COMPONENT_NAME = "dimension_builder";
    private static int buildPercentage = 0;
    private int creative = -1;
    private int state = 0;
    public static int OK = 0;
    public static int ERROR_NOOWNER = -1;
    public static int ERROR_TOOMANYDIMENSIONS = -2;
    private int errorMode = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionBuilderContainer.factory, 1);
    private static int counter = 20;
    private static Random random = new Random();

    public DimensionBuilderTileEntity() {
        super((long)MachineConfiguration.BUILDER_MAXENERGY, (long)MachineConfiguration.BUILDER_RECEIVEPERTICK);
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((DimensionBuilderTileEntity)this).getRSModeInt(), arg_0 -> ((DimensionBuilderTileEntity)this).setRSModeInt(arg_0))};
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int oldstate = this.state;
        super.onDataPacket(net, packet);
        if (oldstate != this.state) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private boolean isCreative() {
        return false;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        NBTTagCompound tagCompound = this.hasTab();
        if (tagCompound == null) {
            this.setState(-1);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setState(-1);
            return;
        }
        int ticksLeft = tagCompound.func_74762_e("ticksLeft");
        if (ticksLeft > 0) {
            ticksLeft = this.createDimensionTick(tagCompound, ticksLeft);
        } else {
            this.maintainDimensionTick(tagCompound);
        }
        this.setState(ticksLeft);
    }

    public NBTTagCompound hasTab() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return null;
        }
        return itemStack.func_77978_p();
    }

    private void maintainDimensionTick(NBTTagCompound tagCompound) {
        int id = tagCompound.func_74762_e("id");
        if (id != 0) {
            long energy;
            long maxEnergy;
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.func_145831_w());
            long rf = this.isCheaterDimension(tagCompound) ? (long)MachineConfiguration.BUILDER_MAXENERGY : this.getStoredPower();
            if (rf > (maxEnergy = (long)PowerConfiguration.MAX_DIMENSION_POWER - (energy = dimensionStorage.getEnergyLevel(id)))) {
                rf = maxEnergy;
            }
            if (Logging.debugMode && --counter < 0) {
                counter = 20;
                Logging.log((String)("#################### id:" + id + ", rf:" + rf + ", energy:" + energy + ", max:" + maxEnergy));
            }
            if (!this.isCheaterDimension(tagCompound)) {
                this.consumeEnergy(rf);
            }
            dimensionStorage.setEnergyLevel(id, energy + rf);
            dimensionStorage.save();
        }
    }

    private int createDimensionTick(NBTTagCompound tagCompound, int ticksLeft) {
        RfToolsDimensionManager manager;
        if (GeneralConfiguration.dimensionBuilderNeedsOwner) {
            int cnt;
            int tickCost;
            if (this.getOwnerUUID() == null) {
                this.errorMode = ERROR_NOOWNER;
                return ticksLeft;
            }
            if (GeneralConfiguration.maxDimensionsPerPlayer >= 0 && (ticksLeft == (tickCost = tagCompound.func_74762_e("tickCost")) || ticksLeft < 5) && (cnt = (manager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w())).countOwnedDimensions(this.getOwnerUUID())) >= GeneralConfiguration.maxDimensionsPerPlayer) {
                this.errorMode = ERROR_TOOMANYDIMENSIONS;
                return ticksLeft;
            }
        }
        this.errorMode = OK;
        int createCost = tagCompound.func_74762_e("rfCreateCost");
        createCost = (int)((float)createCost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.isCheaterDimension(tagCompound) || this.getStoredPower() >= (long)createCost) {
            if (this.isCheaterDimension(tagCompound)) {
                ticksLeft = 0;
            } else {
                this.consumeEnergy(createCost);
                --ticksLeft;
                if (random.nextFloat() < this.getInfusedFactor() && --ticksLeft < 0) {
                    ticksLeft = 0;
                }
            }
            tagCompound.func_74768_a("ticksLeft", ticksLeft);
            if (ticksLeft <= 0) {
                manager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w());
                DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
                String name = tagCompound.func_74779_i("name");
                int id = manager.createNewDimension(this.func_145831_w(), descriptor, name, this.getOwnerName(), this.getOwnerUUID());
                tagCompound.func_74768_a("id", id);
            }
        }
        return ticksLeft;
    }

    private boolean isCheaterDimension(NBTTagCompound tagCompound) {
        if (this.isCreative()) {
            return true;
        }
        String descriptionString = tagCompound.func_74779_i("descriptionString");
        return descriptionString.contains("XCheater");
    }

    public DimensionBuilderBlock.OperationType getState() {
        return DimensionBuilderBlock.OperationType.values()[this.state];
    }

    private void setState(int ticksLeft) {
        int oldstate = this.state;
        this.state = 0;
        this.state = ticksLeft == 0 ? 0 : (ticksLeft == -1 ? 1 : ((ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.markDirtyClient();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return DimensionBuilderContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return DimensionBuilderContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return DimensionBuilderContainer.factory.isOutputSlot(index);
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void requestBuildingPercentage() {
        this.requestDataFromServer("rftoolsdim", CMD_GETBUILDING, TypedMap.EMPTY);
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETBUILDING.equals(command)) {
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return TypedMap.builder().put(PARAM_BUILDING_PROGRESS, (Object)0).build();
            }
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return TypedMap.builder().put(PARAM_BUILDING_PROGRESS, (Object)0).build();
            }
            if (this.errorMode != OK) {
                return TypedMap.builder().put(PARAM_BUILDING_PROGRESS, (Object)this.errorMode).build();
            }
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            return TypedMap.builder().put(PARAM_BUILDING_PROGRESS, (Object)((tickCost - ticksLeft) * 100 / tickCost)).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GETBUILDING.equals(command)) {
            buildPercentage = (Integer)result.get(PARAM_BUILDING_PROGRESS);
            return true;
        }
        return false;
    }

    public static int getBuildPercentage() {
        return buildPercentage;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.state = tagCompound.func_74771_c("state");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("state", (byte)this.state);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }
}

