/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.gui;

import edgarallen.soundmuffler.SuperSoundMuffler;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import edgarallen.soundmuffler.gui.GuiSoundMufflerAddSound;
import edgarallen.soundmuffler.gui.data.IMufflerAccessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSoundMuffler
extends GuiContainer
implements GuiSlider.ISlider {
    private static final ResourceLocation guiTexture = new ResourceLocation("supersoundmuffler", "textures/gui/sound_muffler.png");
    private final IMufflerAccessor muffler;
    private GuiButtonExt modeButton;
    private GuiButtonExt addSoundButton;
    private GuiButtonExt removeSoundButton;
    private GuiSliderExt rangeSlider;
    private GuiSoundList soundList;

    public GuiSoundMuffler(IMufflerAccessor muffler) {
        super(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        });
        this.field_146999_f = 256;
        this.field_147000_g = 170;
        this.muffler = muffler;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String key = this.muffler.isWhiteList() ? "tile.sound_muffler.gui.button.mode.white_list" : "tile.sound_muffler.gui.button.mode.black_list";
        this.modeButton = new GuiButtonExt(0, this.field_147003_i + 159, this.field_147009_r + 5, 90, 14, I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.field_146292_n.add(this.modeButton);
        this.addSoundButton = new GuiButtonExt(1, this.field_147003_i + 159, this.field_147009_r + 151, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.gui.button.add", (Object[])new Object[0]));
        this.field_146292_n.add(this.addSoundButton);
        this.removeSoundButton = new GuiButtonExt(2, this.field_147003_i + 205, this.field_147009_r + 151, 44, 14, I18n.func_135052_a((String)"tile.sound_muffler.gui.button.remove", (Object[])new Object[0]));
        this.removeSoundButton.field_146124_l = false;
        this.field_146292_n.add(this.removeSoundButton);
        if (this.muffler.isRanged()) {
            this.rangeSlider = new GuiSliderExt(3, this.field_147003_i + 7, this.field_147009_r + 151, 128, 14, I18n.func_135052_a((String)"tile.sound_muffler.gui.slider.range", (Object[])new Object[0]), "", 0.0, 19.0, this.muffler.getRangeIndex(), false, false, this);
            this.field_146292_n.add(this.rangeSlider);
        }
        this.soundList = new GuiSoundList(240, 126, this.field_147009_r + 22, this.field_147009_r + 148, this.field_147003_i + 8, 14);
        List<ResourceLocation> sounds = this.muffler.getMuffledSounds();
        sounds.sort(Comparator.comparing(ResourceLocation::toString));
        this.soundList.setSounds(sounds);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.removeSoundButton.field_146124_l = this.soundList.hasSelectedElements();
        List<ResourceLocation> sounds = this.muffler.getMuffledSounds();
        sounds.sort(Comparator.comparing(ResourceLocation::toString));
        this.soundList.setSounds(sounds);
        String key = this.muffler.isWhiteList() ? "tile.sound_muffler.gui.button.mode.white_list" : "tile.sound_muffler.gui.button.mode.black_list";
        this.modeButton.field_146126_j = I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.modeButton.field_146127_k) {
                this.muffler.toggleWhiteList();
                String key = this.muffler.isWhiteList() ? "tile.sound_muffler.gui.button.mode.white_list" : "tile.sound_muffler.gui.button.mode.black_list";
                this.modeButton.field_146126_j = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            } else if (button.field_146127_k == this.addSoundButton.field_146127_k) {
                HashSet<ResourceLocation> unique = new HashSet<ResourceLocation>(SuperSoundMuffler.instance.recentSounds);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSoundMufflerAddSound((GuiScreen)this, this.muffler, new ArrayList<ResourceLocation>(unique)));
            } else if (button.field_146127_k == this.removeSoundButton.field_146127_k) {
                List<ResourceLocation> selectedSounds = this.soundList.getSelectedSounds();
                for (ResourceLocation sound : selectedSounds) {
                    if (sound == null) continue;
                    this.muffler.unmuffleSound(sound);
                }
                this.soundList.clearSelection();
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("Super Sound Muffler: Revived", 8, 9, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        RenderHelper.func_74518_a();
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        this.soundList.drawScreen(mouseX, mouseY, partialTicks);
        RenderHelper.func_74519_b();
    }

    public void onChangeSliderValue(GuiSlider slider) {
        slider.field_146126_j = slider.dispString + " " + TileEntitySoundMuffler.getRange(slider.getValueInt());
        this.muffler.setRange(slider.getValueInt());
    }

    private final class GuiSliderExt
    extends GuiSlider {
        GuiSliderExt(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, @Nullable boolean drawStr, GuiSlider.ISlider par) {
            super(id, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, par);
            this.field_146126_j = this.dispString + " " + TileEntitySoundMuffler.getRange(this.getValueInt());
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.dragging) {
                    this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                    this.updateSlider();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8))), (int)this.field_146129_i, (int)0, (int)66, (int)8, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            }
        }
    }

    private final class GuiSoundList
    extends GuiScrollingList {
        private List<ResourceLocation> sounds;
        private final int slotHeight;
        private List<Integer> selectedIndicies;

        GuiSoundList(int width, int height, int top, int bottom, int left, int slotHeight) {
            super(Minecraft.func_71410_x(), width, height, top, bottom, left, slotHeight, width, height);
            this.selectedIndicies = new ArrayList<Integer>();
            this.slotHeight = slotHeight;
        }

        protected int getSize() {
            return this.sounds.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (GuiScreen.func_146271_m()) {
                if (this.isSelected(index)) {
                    this.removeSelection(index);
                } else {
                    this.selectIndex(index);
                }
            } else if (GuiScreen.func_146272_n()) {
                this.clearSelection();
                int start = index > this.selectedIndex ? this.selectedIndex : index;
                int end = index > this.selectedIndex ? index : this.selectedIndex;
                this.selectRange(start, end);
            } else {
                this.clearSelection();
                this.selectIndex(index);
            }
        }

        protected boolean isSelected(int index) {
            for (int i : this.selectedIndicies) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        void removeSelection(int index) {
            for (int i = 0; i < this.selectedIndicies.size(); ++i) {
                if (this.selectedIndicies.get(i) != index) continue;
                this.selectedIndicies.remove(i);
                return;
            }
        }

        void selectIndex(int index) {
            this.removeSelection(index);
            this.selectedIndicies.add(index);
            this.selectedIndex = index;
        }

        void clearSelection() {
            this.selectedIndicies.clear();
        }

        void selectRange(int start, int end) {
            for (int i = start; i <= end; ++i) {
                this.selectedIndicies.add(i);
            }
            this.selectedIndex = end;
        }

        protected void drawBackground() {
        }

        protected int getContentHeight() {
            return this.getSize() * this.slotHeight + 1;
        }

        protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
            ResourceLocation sound = this.sounds.get(idx);
            GuiSoundMuffler.this.field_146289_q.func_78276_b(GuiSoundMuffler.this.field_146289_q.func_78269_a(sound.toString(), this.listWidth - 10), this.left + 3, top + 2, 0xCCCCCC);
        }

        void setSounds(List<ResourceLocation> sounds) {
            this.sounds = sounds;
        }

        boolean hasSelectedElements() {
            return this.selectedIndicies.size() > 0;
        }

        List<ResourceLocation> getSelectedSounds() {
            ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>();
            for (int i : this.selectedIndicies) {
                ret.add(this.sounds.get(i));
            }
            return ret;
        }
    }
}

