/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.particle;

import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ThEParticle
extends Particle {
    private static final VertexFormat VERTEX_FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    private double[][] texMap = new double[][]{{1.0, 1.0}, {1.0, 0.0}, {0.0, 0.0}, {0.0, 1.0}};
    private float frameHeight;
    private int frameCurr;
    private int frameCount = 1;
    private Color initialTint = Color.WHITE;
    private Color finalTint = Color.WHITE;
    private float initialAlpha = 1.0f;
    private float finalAlpha = 1.0f;
    private float initialScale = 1.0f;
    private float finalScale = 1.0f;
    private float progress;
    private ResourceLocation resourceLocation;

    public ThEParticle(String textureName, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_187130_j -= (double)0.1f;
        this.init(textureName);
    }

    public ThEParticle(String textureName, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.init(textureName);
    }

    protected void init(String textureName) {
        this.resourceLocation = new ResourceLocation("thaumicenergistics", "textures/particle/" + textureName + ".png");
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.processFrame();
    }

    @MethodsReturnNonnullByDefault
    public Particle func_70543_e(float multiplier) {
        this.field_187129_i *= (double)multiplier;
        this.field_187130_j *= (double)multiplier;
        this.field_187131_k *= (double)multiplier;
        return this;
    }

    public void processFrame() {
        this.progress = (float)this.field_70546_d / (float)this.field_70547_e;
        if (this.frameCount > 1) {
            this.frameCurr = Math.round(this.progress * (float)(this.frameCount - 1));
            float frameCurrTop = this.frameHeight * (float)this.frameCurr;
            float frameCurrBottom = frameCurrTop + this.frameHeight;
            this.texMap = new double[][]{{1.0, frameCurrBottom}, {1.0, frameCurrTop}, {0.0, frameCurrTop}, {0.0, frameCurrBottom}};
        }
        if (this.initialAlpha != this.finalAlpha) {
            this.field_82339_as = this.valFromProgress(this.initialAlpha, this.finalAlpha);
        }
        if (this.initialScale != this.finalScale) {
            this.field_70544_f = this.valFromProgress(this.initialScale, this.finalScale);
        }
        if (!this.initialTint.equals(this.finalTint)) {
            this.func_70538_b(this.valFromProgress(this.initialTint.getRed(), this.finalTint.getRed()), this.valFromProgress(this.initialTint.getGreen(), this.finalTint.getGreen()), this.valFromProgress(this.initialTint.getBlue(), this.finalTint.getBlue()));
        }
    }

    public void setRBGColorF(int r, int g, int b) {
        this.func_70538_b((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    protected float valFromProgress(float init, float fin) {
        return init + this.progress * (fin - init);
    }

    protected float getRand(float deviation) {
        return 1.0f - deviation + this.field_187136_p.nextFloat() * 2.0f * deviation;
    }

    @ParametersAreNonnullByDefault
    public void func_180434_a(BufferBuilder bufferIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        this.processFrame();
        float vecScale = 0.1f * this.field_70544_f;
        float xInterp = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float yInterp = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float zInterp = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int skyL = brightness >> 16 & 0xFFFF;
        int blockL = brightness & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-(rotationX *= vecScale) - (rotationXY *= vecScale)), (double)(-(rotationZ *= vecScale)), (double)(-(rotationYZ *= vecScale) - (rotationXZ *= vecScale))), new Vec3d((double)(-rotationX + rotationXY), (double)rotationZ, (double)(-rotationYZ + rotationXZ)), new Vec3d((double)(rotationX + rotationXY), (double)rotationZ, (double)(rotationYZ + rotationXZ)), new Vec3d((double)(rotationX - rotationXY), (double)(-rotationZ), (double)(rotationYZ - rotationXZ))};
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_82339_as);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocation);
        if (this.field_190014_F != 0.0f) {
            float angleInterp = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float vecMod = MathHelper.func_76134_b((float)(angleInterp * 0.5f));
            float vecModSq = vecMod * vecMod;
            float vecMod2 = 2.0f * vecMod;
            float sin = MathHelper.func_76126_a((float)(angleInterp * 0.5f));
            float xComponent = sin * (float)ThEParticle.field_190016_K.field_72450_a;
            float yComponent = sin * (float)ThEParticle.field_190016_K.field_72448_b;
            float zComponent = sin * (float)ThEParticle.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)xComponent, (double)yComponent, (double)zComponent);
            for (int i = 0; i < 4; ++i) {
                avec3d[i] = vec3d.func_186678_a(2.0 * avec3d[i].func_72430_b(vec3d)).func_178787_e(avec3d[i].func_186678_a((double)vecModSq - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[i]).func_186678_a((double)vecMod2));
            }
        }
        bufferIn.func_181668_a(7, VERTEX_FORMAT);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        for (int i = 0; i < 4; ++i) {
            bufferIn.func_181662_b((double)xInterp + avec3d[i].field_72450_a, (double)yInterp + avec3d[i].field_72448_b, (double)zInterp + avec3d[i].field_72449_c).func_187315_a(this.texMap[i][0], this.texMap[i][1]).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyL, blockL).func_181663_c(0.0f, 0.0f, 0.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    public ThEParticle setGravity(float gravity) {
        this.field_70545_g = gravity;
        return this;
    }

    public ThEParticle setAlpha(float initialAlpha, float finalAlpha, float randomness) {
        this.initialAlpha = initialAlpha;
        this.finalAlpha = finalAlpha;
        if (randomness > 0.0f) {
            this.initialAlpha *= this.safeFloat(this.getRand(randomness));
            this.finalAlpha *= this.safeFloat(this.getRand(randomness));
        }
        this.field_82339_as = this.initialAlpha;
        return this;
    }

    public ThEParticle setScale(float initialScale, float finalScale, float randomness) {
        this.initialScale = initialScale;
        this.finalScale = finalScale;
        if (randomness > 0.0f) {
            this.initialScale *= this.getRand(randomness);
            this.finalScale *= this.getRand(randomness);
        }
        this.field_70544_f = this.initialScale;
        return this;
    }

    public ThEParticle setTint(Color initialTint, Color finalTint, float randomness) {
        this.initialTint = initialTint;
        this.finalTint = finalTint;
        if (randomness > 0.0f) {
            this.initialTint = this.randColor(this.initialTint, randomness);
            this.finalTint = this.randColor(this.finalTint, randomness);
        }
        this.setRBGColorF(this.initialTint.getRed(), this.initialTint.getGreen(), this.initialTint.getBlue());
        return this;
    }

    protected Color randColor(Color color, float randomness) {
        return this.safeColor((float)color.getRed() * this.getRand(randomness) / 255.0f, (float)color.getGreen() * this.getRand(randomness) / 255.0f, (float)color.getBlue() * this.getRand(randomness) / 255.0f);
    }

    protected Color safeColor(float r, float g, float b) {
        return new Color(this.safeFloat(r), this.safeFloat(g), this.safeFloat(b));
    }

    protected float safeFloat(float x) {
        return Math.max(Math.min(x, 1.0f), 0.0f);
    }

    public void setFrameCount(int frameCount) {
        this.frameHeight = 1.0f / (float)frameCount;
        this.frameCount = frameCount;
        this.frameCurr = 0;
    }
}

