/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.config;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.TerminalStyle;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.config.PrefixSetting;

@Config(modid="thaumicenergistics")
public class ThEConfig
implements IThEConfig {
    @Config.Name(value="Essentia Container Capacity")
    @Config.Comment(value={"Specifies how much a item that holds essentia can hold\nFor filling with Essentia Terminal\nBest to set it to how much the item can actually store"})
    public static Map<String, Integer> essentiaContainerCapacity = new HashMap<String, Integer>();
    @Config.Name(value="Tick Rates")
    public static TickRates tickRates = new TickRates();
    @Config.Name(value="Client Config")
    public static Client client = new Client();

    @Override
    public Map<String, Integer> essentiaContainerCapacity() {
        return new HashMap<String, Integer>(essentiaContainerCapacity);
    }

    @Override
    public int tickTimeEssentiaImportBusMin() {
        return ThEConfig.tickRates.tickTimeEssentiaImportBusMin;
    }

    @Override
    public int tickTimeEssentiaImportBusMax() {
        return ThEConfig.tickRates.tickTimeEssentiaImportBusMax;
    }

    @Override
    public int tickTimeEssentiaExportBusMin() {
        return ThEConfig.tickRates.tickTimeEssentiaExportBusMin;
    }

    @Override
    public int tickTimeEssentiaExportBusMax() {
        return ThEConfig.tickRates.tickTimeEssentiaExportBusMax;
    }

    @Override
    public int tickTimeEssentiaStorageBusMin() {
        return ThEConfig.tickRates.tickTimeEssentiaStorageBusMin;
    }

    @Override
    public int tickTimeEssentiaStorageBusMax() {
        return ThEConfig.tickRates.tickTimeEssentiaStorageBusMax;
    }

    @Override
    public int tickTimeArcaneAssemblerMin() {
        return ThEConfig.tickRates.tickTimeArcaneAssemblerMin;
    }

    @Override
    public int tickTimeArcaneAssemblerMax() {
        return ThEConfig.tickRates.tickTimeArcaneAssemblerMax;
    }

    @Override
    public TerminalStyle terminalStyle() {
        return ThEConfig.client.terminalStyle;
    }

    @Override
    public SearchBoxMode searchBoxMode() {
        return ThEConfig.client.searchBoxMode;
    }

    @Override
    public String modSearchPrefix() {
        return ThEConfig.client.modSearchPrefix;
    }

    @Override
    public PrefixSetting modSearchSetting() {
        return ThEConfig.client.modSearchSetting;
    }

    @Override
    public String aspectSearchPrefix() {
        return ThEConfig.client.aspectSearchPrefix;
    }

    @Override
    public PrefixSetting aspectSearchSetting() {
        return ThEConfig.client.aspectSearchSetting;
    }

    @Override
    public double arcaneAssemblerParticleMultiplier() {
        return ThEConfig.client.arcaneAssemblerParticleMultiplier;
    }

    public static void save() {
        ConfigManager.sync((String)"thaumicenergistics", (Config.Type)Config.Type.INSTANCE);
    }

    static {
        essentiaContainerCapacity.put("thaumcraft:phial", 10);
    }

    public static class TickRates {
        @Config.Name(value="Essentia Import Bus Min")
        public int tickTimeEssentiaImportBusMin = 5;
        @Config.Name(value="Essentia Import Bus Max")
        public int tickTimeEssentiaImportBusMax = 40;
        @Config.Name(value="Essentia Export Bus Min")
        public int tickTimeEssentiaExportBusMin = 5;
        @Config.Name(value="Essentia Export Bus Max")
        public int tickTimeEssentiaExportBusMax = 60;
        @Config.Name(value="Essentia Storage Bus Min")
        public int tickTimeEssentiaStorageBusMin = 5;
        @Config.Name(value="Essentia Storage Bus Max")
        public int tickTimeEssentiaStorageBusMax = 60;
        @Config.Name(value="Arcane Assembler Min")
        public int tickTimeArcaneAssemblerMin = 2;
        @Config.Name(value="Arcane Assembler Max")
        public int tickTimeArcaneAssemblerMax = 40;

        private TickRates() {
        }
    }

    public static class Client {
        @Config.Name(value="Terminal Style")
        public TerminalStyle terminalStyle = TerminalStyle.TALL;
        @Config.Name(value="Search Box Mode")
        public SearchBoxMode searchBoxMode = SearchBoxMode.AUTOSEARCH;
        @Config.Name(value="Mod Search Prefix")
        public String modSearchPrefix = "@";
        @Config.Name(value="Mod Search Setting")
        public PrefixSetting modSearchSetting = PrefixSetting.REQUIRE_PREFIX;
        @Config.Name(value="Aspect Search Prefix")
        public String aspectSearchPrefix = "#";
        @Config.Name(value="Aspect Search Setting")
        public PrefixSetting aspectSearchSetting = PrefixSetting.REQUIRE_PREFIX;
        @Config.Name(value="Arcane Assembler Particle Multiplier")
        public double arcaneAssemblerParticleMultiplier = 1.0;

        private Client() {
        }
    }
}

