/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration;

import java.util.HashMap;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import thaumicenergistics.integration.IThEIntegration;
import thaumicenergistics.integration.appeng.ThEAppliedEnergistics;
import thaumicenergistics.integration.hwyla.ThEHwyla;
import thaumicenergistics.integration.invtweaks.ThEInvTweaks;
import thaumicenergistics.integration.thaumcraft.ThEThaumcraft;
import thaumicenergistics.integration.theoneprobe.ThETheOneProbe;
import thaumicenergistics.util.ThELog;

public class ThEIntegrationLoader {
    private static final HashMap<IThEIntegration, String> INTEGRATIONS = new HashMap();
    private static final ModAPIManager apiManager = ModAPIManager.INSTANCE;

    private static void registerIntegration(String modId, Class<? extends IThEIntegration> integration) {
        if (Loader.isModLoaded((String)modId) || apiManager.hasAPI(modId)) {
            try {
                INTEGRATIONS.put(integration.newInstance(), modId);
                ThELog.info("Integrations: Registered [" + modId + "]", new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                ThELog.error("Failed to instantiate an integration class", ex);
            }
        } else {
            ThELog.debug("Integrations: Not found [" + modId + "]", new Object[0]);
        }
    }

    public static String getModId(IThEIntegration integration) {
        return INTEGRATIONS.get(integration);
    }

    public static void preInit() {
        ThELog.info("Integrations: PreInit", new Object[0]);
        INTEGRATIONS.keySet().forEach(IThEIntegration::preInit);
    }

    public static void init() {
        ThELog.info("Integrations: Init", new Object[0]);
        INTEGRATIONS.keySet().forEach(IThEIntegration::init);
    }

    public static void postInit() {
        ThELog.info("Integrations: PostInit", new Object[0]);
        INTEGRATIONS.keySet().forEach(IThEIntegration::postInit);
    }

    static {
        ThEIntegrationLoader.registerIntegration("thaumcraft", ThEThaumcraft.class);
        ThEIntegrationLoader.registerIntegration("appliedenergistics2", ThEAppliedEnergistics.class);
        ThEIntegrationLoader.registerIntegration("inventorytweaks", ThEInvTweaks.class);
        ThEIntegrationLoader.registerIntegration("waila", ThEHwyla.class);
        ThEIntegrationLoader.registerIntegration("theoneprobe", ThETheOneProbe.class);
    }
}

