/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.part.ContainerSharedEssentiaBus;
import thaumicenergistics.container.slot.SlotGhostEssentia;
import thaumicenergistics.util.ThELog;

public class PacketGhostEssentia
implements IMessage {
    private Aspect aspect;
    private int slot;

    public PacketGhostEssentia() {
    }

    public PacketGhostEssentia(Aspect aspect, int slot) {
        this.aspect = aspect;
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        String tag = ByteBufUtils.readUTF8String((ByteBuf)buf);
        ThELog.debug("Read aspect '{}' from bytes", tag);
        this.aspect = Aspect.getAspect((String)tag);
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.aspect.getTag());
        buf.writeInt(this.slot);
    }

    public static class Handler
    implements IMessageHandler<PacketGhostEssentia, IMessage> {
        public IMessage onMessage(PacketGhostEssentia message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            IThreadListener threadListener = (IThreadListener)player.field_70170_p;
            threadListener.func_152344_a(() -> {
                Slot invSlot;
                Container openContainer = player.field_71070_bA;
                ThELog.debug("Server received aspect '{}' using slot '{}'", message.aspect.getName(), openContainer);
                if (!(openContainer instanceof ContainerSharedEssentiaBus)) {
                    return;
                }
                if (message.slot >= 0 && message.slot < openContainer.field_75151_b.size() && (invSlot = openContainer.func_75139_a(message.slot)) instanceof SlotGhostEssentia) {
                    SlotGhostEssentia ghostEssentiaSlot = (SlotGhostEssentia)invSlot;
                    ghostEssentiaSlot.setAspect(message.aspect);
                }
            });
            return null;
        }
    }
}

