/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.config.AESettings;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.integration.appeng.grid.IThEGridHost;
import thaumicenergistics.integration.appeng.grid.ThEGridBlock;
import thaumicenergistics.integration.appeng.util.ThEActionSource;
import thaumicenergistics.integration.appeng.util.ThEConfigManager;
import thaumicenergistics.item.ItemPartBase;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.IThEGridNodeBlock;
import thaumicenergistics.util.IThEOwnable;
import thaumicenergistics.util.ItemHandlerUtil;
import thaumicenergistics.util.inventory.IThEInvTile;

public abstract class PartBase
implements IPart,
IThEGridHost,
IUpgradeableHost,
IActionHost,
IPowerChannelState,
IThEInvTile,
IThEOwnable,
IThEGridNodeBlock {
    protected ThEConfigManager configManager = new ThEConfigManager();
    protected ThEGridBlock gridBlock;
    protected IGridNode gridNode;
    protected IPartHost host;
    protected TileEntity hostTile;
    protected EntityPlayer owner;
    protected ItemPartBase item;
    protected int lightOpacity = -1;
    public AEPartLocation side;
    public IActionSource source;
    protected boolean isPowered;
    protected boolean isActive;

    public PartBase(ItemPartBase item) {
        this.item = item;
        this.source = new ThEActionSource(this);
        this.getConfigManager().registerSettings(this.getAESettingSubject());
    }

    protected abstract AESettings.SUBJECT getAESettingSubject();

    public void settingChanged(Settings setting) {
    }

    public ItemStack getRepr() {
        return new ItemStack((Item)this.item);
    }

    public ItemStack getItemStack(PartItemStack type) {
        return this.getRepr();
    }

    public boolean canWork() {
        return false;
    }

    public double getIdlePowerUsage() {
        return 0.0;
    }

    @Override
    public DimensionalCoord getLocation() {
        if (this.hostTile != null && this.hostTile.func_145830_o() && this.hostTile.func_145831_w().field_73011_w != null) {
            return new DimensionalCoord(this.hostTile.func_145831_w(), this.hostTile.func_174877_v());
        }
        return null;
    }

    public boolean requireDynamicRender() {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.gridNode != null) {
            this.gridNode.saveToNBT("part", nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (this.gridNode != null) {
            this.gridNode.loadFromNBT("part", nbt);
        }
    }

    protected int blockLight(int emit) {
        if (this.lightOpacity >= 0) {
            return (int)((float)emit * ((float)this.lightOpacity / 255.0f));
        }
        TileEntity te = this.getTile();
        this.lightOpacity = 255 - te.func_145831_w().getBlockLightOpacity(te.func_174877_v().func_177972_a(this.side.getFacing()));
        return this.lightOpacity;
    }

    public ThEConfigManager getConfigManager() {
        return this.configManager;
    }

    public int getLightLevel() {
        return 0;
    }

    public boolean isLadder(EntityLivingBase entityLivingBase) {
        return false;
    }

    public void onNeighborChanged(IBlockAccess iBlockAccess, BlockPos blockPos, BlockPos blockPos1) {
        this.host.markForUpdate();
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    public void writeToStream(ByteBuf buf) {
        buf.writeBoolean(this.isActive());
        buf.writeBoolean(this.isPowered());
    }

    public boolean readFromStream(ByteBuf buf) {
        this.isActive = buf.readBoolean();
        this.isPowered = buf.readBoolean();
        return true;
    }

    @Override
    public IGridNode getGridNode() {
        return this.gridNode;
    }

    public void onEntityCollision(Entity entity) {
    }

    public void removeFromWorld() {
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void addToWorld() {
        if (ForgeUtil.isClient()) {
            return;
        }
        this.gridBlock = new ThEGridBlock(this);
        this.gridNode = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
        this.initGridNodeOwner();
        this.gridNode.updateState();
        BlockPos pos = this.gridBlock.getLocation().getPos();
        this.onNeighborChanged(null, pos, pos.func_177972_a(this.side.getFacing()));
    }

    public IGridNode getExternalFacingNode() {
        return null;
    }

    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity te) {
        this.side = side;
        this.host = host;
        this.hostTile = te;
    }

    public boolean onActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public boolean onShiftActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public void getDrops(List<ItemStack> list, boolean b) {
        list.addAll(ItemHandlerUtil.getInventoryAsList(this.getInventoryByName("upgrades")));
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 3.0f;
    }

    public void randomDisplayTick(World world, BlockPos blockPos, Random random) {
    }

    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack stack, AEPartLocation side) {
        this.setOwner(player);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    @Override
    public EntityPlayer getOwner() {
        return this.owner;
    }

    public boolean canBePlacedOn(BusSupport busSupport) {
        return busSupport == BusSupport.CABLE;
    }

    public void getBoxes(IPartCollisionHelper box) {
        box.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        box.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        return this.gridNode;
    }

    @Override
    public ThEGridBlock getGridBlock() {
        return this.gridBlock;
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.GLASS;
    }

    public void securityBreak() {
        if (this.getRepr().func_190926_b() || this.getGridNode() == null) {
            return;
        }
        this.host.removePart(this.side, false);
        EnumFacing facing = this.side.getFacing();
        Vec3d offset = new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        offset = offset.func_186678_a(0.5);
        BlockPos pos = this.getTile().func_174877_v();
        Vec3d posVec = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5).func_178787_e(offset);
        World world = this.getTile().func_145831_w();
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)world.func_180495_p(pos)));
        world.func_72838_d((Entity)new EntityItem(world, posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c, this.getRepr().func_77946_l()));
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.gridNode != null ? this.gridNode.isActive() : this.isActive;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.gridNode;
    }

    @MENetworkEventSubscribe
    public void updateBootStatus(MENetworkBootingStatusChange event) {
        this.host.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void updatePowerStatus(MENetworkPowerStatusChange event) {
        try {
            this.isPowered = GridUtil.getEnergyGrid(this).isNetworkPowered();
            this.host.markForUpdate();
        }
        catch (GridAccessException e) {
            this.isPowered = false;
        }
    }

    @Override
    public void gridChanged() {
    }

    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    public TileEntity getTile() {
        return this.hostTile;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        return null;
    }
}

