/*
 * Decompiled with CFR 0.152.
 */
package shnupbups.tinkersaether.tools;

import com.gildedgames.the_aether.entities.projectile.darts.EntityDartEnchanted;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartGolden;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartPoison;
import com.gildedgames.the_aether.items.ItemsAether;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import shnupbups.tinkersaether.modules.ModuleTools;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ToolDartShooter
extends BowCore {
    private ImmutableList<Item> dartMatches = null;

    public ToolDartShooter() {
        super(new PartMaterialType[]{PartMaterialType.bow((IToolPart)ModuleTools.tube), PartMaterialType.extra((IToolPart)ModuleTools.mouthpiece)});
        this.func_77655_b("dart_shooter").setRegistryName("dart_shooter");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{null, null});
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 1.0f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int getDrawTime() {
        return 1;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public float baseProjectileDamage() {
        return 1.0f;
    }

    public float projectileDamageModifier() {
        return 1.0f;
    }

    public void playShootSound(float power, World world, EntityPlayer entityPlayer) {
        world.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 0.5f + field_77697_d.nextFloat() * 0.1f);
    }

    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        BowMaterialStats tube = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(0).getStatsOrUnknown("head");
        ExtraMaterialStats mouthpiece = (ExtraMaterialStats)materials.get(1).getStatsOrUnknown("extra");
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(1).getStatsOrUnknown("handle");
        data.limb(new BowMaterialStats[]{tube});
        data.head(new HeadMaterialStats[]{head});
        data.extra(new ExtraMaterialStats[]{mouthpiece});
        data.handle(new HandleMaterialStats[]{handle});
        data.bonusDamage *= 0.5f;
        return data;
    }

    public float damagePotential() {
        return 0.2f;
    }

    public double attackSpeed() {
        return 4.0;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ToolHelper.isBroken((ItemStack)itemStackIn)) {
            return super.func_77659_a(worldIn, playerIn, hand);
        }
        super.func_77615_a(itemStackIn, worldIn, (EntityLivingBase)playerIn, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Nonnull
    protected ItemStack getCreativeProjectileStack() {
        return new ItemStack(ItemsAether.dart);
    }

    protected List<Item> getAmmoItems() {
        if (this.dartMatches == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (ModuleTools.dart != null) {
                builder.add((Object)ModuleTools.dart);
            }
            builder.add((Object)ItemsAether.dart);
            this.dartMatches = builder.build();
        }
        return this.dartMatches;
    }

    public EntityArrow getProjectileEntity(ItemStack ammo, ItemStack bow, World world, EntityPlayer player, float power, float inaccuracy, float progress, boolean usedAmmo) {
        if (ammo.func_77973_b() == ItemsAether.dart) {
            Object projectile = ammo.func_77960_j() == 0 ? new EntityDartGolden(world, (EntityLivingBase)player) : (ammo.func_77960_j() == 1 ? new EntityDartPoison(world, (EntityLivingBase)player) : new EntityDartEnchanted(world, (EntityLivingBase)player));
            projectile.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, power, inaccuracy);
            if (player.field_71075_bZ.field_75098_d) {
                projectile.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            } else if (!usedAmmo) {
                projectile.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            }
            return projectile;
        }
        return super.getProjectileEntity(ammo, bow, world, player, power, inaccuracy, progress, usedAmmo);
    }
}

