/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.item;

import com.valkyrieofnight.vlib.core.util.client.InfoUtil;
import com.valkyrieofnight.vliblegacy.lib.sys.item.tooltip.IProvideTooltipInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VLItemBlock
extends ItemBlock {
    public EnumRarity rarity = EnumRarity.COMMON;
    public IProvideTooltipInfo tooltipProvider;

    public VLItemBlock(Block block) {
        super(block);
        if (block instanceof IProvideTooltipInfo) {
            this.tooltipProvider = (IProvideTooltipInfo)block;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        if (this.tooltipProvider == null) {
            return;
        }
        this.tooltipProvider.addTooltipInfo(stack, worldIn, tooltip, flag);
        if (this.tooltipProvider.hasShiftTooltipInfo()) {
            if (InfoUtil.ENABLE_SHIFT_INFORMATION && !InfoUtil.isShiftDown()) {
                tooltip.add(InfoUtil.shiftForInfo());
            }
            if (InfoUtil.isShiftDown()) {
                this.tooltipProvider.addShiftTooltipInfo(stack, worldIn, tooltip, flag);
            }
        }
    }

    public void setRarity(EnumRarity rarity, int meta) {
        this.rarity = rarity;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack != null) {
            return this.getRarityFromMeta(stack.func_77960_j());
        }
        return EnumRarity.COMMON;
    }

    public EnumRarity getRarityFromMeta(int meta) {
        return this.rarity;
    }
}

