/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.item;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.impl.util.TotallyImmutableItemStack;

@ZenClass(value="mods.zenutils.ItemHandler")
@IterableSimple(value="crafttweaker.item.IItemStack")
@ZenRegister
public class CrTItemHandler
implements Iterable<IItemStack> {
    private final IItemHandler itemHandler;

    private CrTItemHandler(IItemHandler itemHandler) {
        Objects.requireNonNull(itemHandler);
        this.itemHandler = itemHandler;
    }

    public static CrTItemHandler of(IItemHandler itemHandler) {
        return itemHandler == null ? null : new CrTItemHandler(itemHandler);
    }

    @ZenGetter
    public int size() {
        return this.itemHandler.getSlots();
    }

    @Override
    @Nonnull
    public Iterator<IItemStack> iterator() {
        return IntStream.range(0, this.size()).mapToObj(this::getStackInSlot).iterator();
    }

    @ZenMethod
    public IItemStack getStackInSlot(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        return stack.func_190926_b() ? null : new TotallyImmutableItemStack(stack);
    }

    @ZenMethod
    public IItemStack insertItem(int slot, IItemStack stack, boolean simulate) {
        return CraftTweakerMC.getIItemStack((ItemStack)this.itemHandler.insertItem(slot, CraftTweakerMC.getItemStack((IItemStack)stack), simulate));
    }

    @ZenMethod
    public IItemStack extractItem(int slot, int amount, boolean simulate) {
        return CraftTweakerMC.getIItemStack((ItemStack)this.itemHandler.extractItem(slot, amount, simulate));
    }

    @ZenMethod
    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @ZenMethod
    public boolean isItemValid(int slot, IItemStack stack) {
        return this.itemHandler.isItemValid(slot, CraftTweakerMC.getItemStack((IItemStack)stack));
    }
}

