/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.util;

import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Logger {
    private static Minecraft mc;
    private static org.apache.logging.log4j.Logger logger;

    public static void init(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        mc = Minecraft.func_71410_x();
    }

    public static void debug(Object ... args) {
        if (GlobalConfig.configLoaded && CommonConfig.globalConfig.debugLog) {
            StringBuilder mes = new StringBuilder();
            for (Object obj : args) {
                if (obj instanceof String) {
                    mes.append(obj);
                    continue;
                }
                if (obj instanceof Number) {
                    mes.append(String.valueOf(obj));
                    continue;
                }
                try {
                    mes.append(String.valueOf(obj));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (logger != null) {
                logger.info(mes.toString());
                Logger.addChatMessage(TextFormatting.GRAY + "D: " + mes.toString() + TextFormatting.RESET);
            } else {
                System.out.println("debug: " + mes.toString());
            }
        }
    }

    public static void info(String str) {
        if (logger != null) {
            logger.info(str);
            Logger.addChatMessage(TextFormatting.AQUA + "I: " + str + TextFormatting.RESET);
        } else {
            System.out.println("info: " + str);
        }
    }

    public static void warn(String str) {
        if (logger != null) {
            logger.warn(str);
            Logger.addChatMessage(TextFormatting.YELLOW + "W: " + str + TextFormatting.RESET);
        } else {
            System.out.println("warn: " + str);
        }
    }

    public static void error(String str) {
        if (logger != null) {
            logger.error(str);
            Logger.addChatMessage(TextFormatting.RED + "E: " + str + TextFormatting.RESET);
        } else {
            System.out.println("error: " + str);
        }
    }

    private static void addChatMessage(String str) {
        if (CommonConfig.globalConfig.chatMsg) {
            Logger.printChatMessage(str);
        }
    }

    public static void printChatMessage(String str) {
        if (mc != null && Logger.mc.field_71456_v != null) {
            Logger.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(str));
        }
    }

    public static String toString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static void logInfo(String str) {
        System.out.println(str);
    }

    public static void logDebug(String str) {
        if (GlobalConfig.coreDebug) {
            System.out.println(str);
        }
    }
}

