/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandCelestialBodyInfo
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "find_celestial_body";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <name>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new WrongUsageException("Not enough arguments, usage: " + this.func_71518_a(sender), new Object[0]);
        }
        ArrayList<Object> foundBodies = new ArrayList<Object>();
        String name = args[0].toLowerCase();
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        for (CelestialBody body : celestialBodyList) {
            if (!body.getLocalizedName().toLowerCase().contains(name)) continue;
            foundBodies.add(body);
        }
        Collection systems = GalaxyRegistry.getRegisteredSolarSystems().values();
        for (SolarSystem solarSystem : systems) {
            if (!solarSystem.getMainStar().getLocalizedName().toLowerCase().contains(name)) continue;
            foundBodies.add(solarSystem.getMainStar());
        }
        if (foundBodies.isEmpty()) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("info.message.celestialbodysearch.none", new Object[]{name}));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("info.message.celestialbodysearch.some", new Object[]{foundBodies.size(), name}));
            for (CelestialBody celestialBody : foundBodies) {
                StringBuilder sb = new StringBuilder();
                sb.append(celestialBody.getLocalizedName());
                sb.append(" : ");
                sb.append(celestialBody.getName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
            }
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

