/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.asteroidWorld;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.world.WorldGenTallgrassMeta;
import de.katzenpapst.amunra.world.WorldGenTreeBySapling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.BiomeGenBaseAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;

public class AmunRaAsteroidsChunkProvider
extends ChunkProviderGenerate {
    protected Map<BlockMetaPair, Integer> extraOreGen = new HashMap<BlockMetaPair, Integer>();
    protected BlockMetaPair[] asteroidStoneBlocks;
    protected BlockMetaPair denseIce;
    protected BlockMetaPair dirt;
    protected BlockMetaPair grass;
    protected BlockMetaPair light;
    protected WorldGenData[] generatorsTrees;
    protected WorldGenData[] generatorsGrass;
    protected WorldGenData[] generatorsLakes;
    private final Random rand;
    private final World worldObj;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    protected final SpecialAsteroidBlockHandler coreHandler;
    protected final SpecialAsteroidBlockHandler shellHandler;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int MAX_ASTEROID_RADIUS = 25;
    private static final int MIN_ASTEROID_RADIUS = 5;
    private static final int MAX_ASTEROID_SKEW = 8;
    private static final int MIN_ASTEROID_Y = 48;
    private static final int MAX_ASTEROID_Y = 208;
    private static final int ASTEROID_CHANCE = 800;
    private static final int ASTEROID_SHELL_CHANCE = 2;
    private static final int MIN_BLOCKS_PER_CHUNK = 50;
    private static final int MAX_BLOCKS_PER_CHUNK = 200;
    private static final int NOISE_OFFSET_SIZE = 256;
    private static final float MIN_HOLLOW_SIZE = 0.6f;
    private static final float MAX_HOLLOW_SIZE = 0.8f;
    private static final int HOLLOW_CHANCE = 10;
    private static final int MIN_RADIUS_FOR_HOLLOW = 15;
    private static final int TALL_GRASS_CHANCE = 2;
    private static final int GLOWSTONE_CHANCE = 20;
    private final List<AsteroidData> largeAsteroids = new ArrayList<AsteroidData>();
    private static final Set<BlockVec3> CHUNKS_DONE = new HashSet<BlockVec3>();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;

    public AmunRaAsteroidsChunkProvider(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.worldObj = world;
        this.rand = new Random(seed);
        this.asteroidStoneBlocks = new BlockMetaPair[]{new BlockMetaPair(AsteroidBlocks.blockBasic, 0), new BlockMetaPair(AsteroidBlocks.blockBasic, 1), new BlockMetaPair(AsteroidBlocks.blockBasic, 2)};
        this.shellHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.initBlockTypes();
    }

    protected void initBlockTypes() {
        BlockMetaPair oreAlu = new BlockMetaPair(AsteroidBlocks.blockBasic, 3);
        BlockMetaPair oreTitanium = new BlockMetaPair(AsteroidBlocks.blockBasic, 4);
        BlockMetaPair oreIron = new BlockMetaPair(AsteroidBlocks.blockBasic, 5);
        BlockMetaPair oreSilicon = new BlockMetaPair(GCBlocks.basicBlock, 8);
        BlockMetaPair oreMeteorIron = new BlockMetaPair(GCBlocks.basicBlock, 12);
        this.denseIce = new BlockMetaPair(AsteroidBlocks.blockDenseIce, 0);
        this.dirt = ARBlocks.blockMethaneDirt;
        this.grass = ARBlocks.blockVacuumGrass;
        this.light = new BlockMetaPair(Blocks.field_150426_aN, 0);
        this.generatorsTrees = new WorldGenData[]{new WorldGenData((WorldGenerator)new WorldGenTreeBySapling(false, 5, ARBlocks.blockMethaneSapling), 2)};
        this.generatorsGrass = new WorldGenData[]{new WorldGenData(new WorldGenTallgrassMeta(ARBlocks.blockMethaneTGrass), 2)};
        this.generatorsLakes = new WorldGenData[]{new WorldGenData((WorldGenerator)new WorldGenLakes(Blocks.field_150355_j), 2), new WorldGenData((WorldGenerator)new WorldGenLakes(Blocks.field_150353_l), 2)};
        this.addBlockToHandler(this.coreHandler, this.asteroidStoneBlocks[2], 5, 0.3);
        this.addBlockToHandler(this.coreHandler, this.asteroidStoneBlocks[1], 7, 0.3);
        this.addBlockToHandler(this.coreHandler, this.asteroidStoneBlocks[0], 1, 0.25);
        this.addBlockToHandler(this.coreHandler, oreAlu, 15, 0.2);
        this.addBlockToHandler(this.coreHandler, oreTitanium, 10, 0.15);
        this.addBlockToHandler(this.coreHandler, oreIron, 23, 0.2);
        this.addBlockToHandler(this.coreHandler, oreSilicon, 12, 0.15);
        this.addBlockToHandler(this.coreHandler, oreMeteorIron, 6, 0.13);
        this.extraOreGen.put(oreTitanium, 400);
        this.extraOreGen.put(oreAlu, 250);
        this.extraOreGen.put(oreIron, 300);
        this.addBlockToHandler(this.shellHandler, this.asteroidStoneBlocks[0], 1, 0.15);
        this.addBlockToHandler(this.shellHandler, this.asteroidStoneBlocks[1], 3, 0.15);
        this.addBlockToHandler(this.shellHandler, this.asteroidStoneBlocks[2], 1, 0.15);
        this.addBlockToHandler(this.shellHandler, this.denseIce, 1, 0.15);
    }

    protected void addBlockToHandler(SpecialAsteroidBlockHandler handler, BlockMetaPair b, int probability, double thickness) {
        handler.addBlock(new SpecialAsteroidBlock(b.getBlock(), b.getMetadata(), probability, thickness));
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        Random random = new Random();
        int asteroidChance = 800;
        int rangeY = 160;
        int rangeSize = 20;
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + 16;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        int size = random.nextInt(20) + 5;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, idArray, metaArray, flagDataOnly);
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, Block[] blockArray, byte[] metaArray, boolean flagDataOnly) {
        int indexBaseX;
        int distanceX;
        int indexXZ;
        int indexXY;
        int x;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand, size);
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand, size);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * 0.19999999f + 0.6f;
        if (rand.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(this.denseIce.getBlock(), this.denseIce.getMetadata(), 1, 0.15);
        }
        ((WorldProviderAsteroids)this.worldObj.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx = x2 * zSize;
            float xxx = (float)x2 + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidX, asteroidY, asteroidZ);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z = 0; z < zSize; ++z) {
                sizeXArray[yy + z] = this.asteroidSkewX.getNoise(yyy, (float)z + noiseOffsetZ);
            }
        }
        for (int x3 = 0; x3 < xSize; ++x3) {
            int xx = x3 * ySize;
            float xxx = (float)x3 + noiseOffsetX;
            for (int y = 0; y < ySize; ++y) {
                sizeZArray[xx + y] = this.asteroidSkewZ.getNoise(xxx, (float)y + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x = xMax - 1; x >= xMin; --x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            indexBaseX = x * 256 << 4;
            float xx = x + chunkX;
            for (int z = zMin; z < zMax; ++z) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z + chunkZ);
                int indexBase = indexBaseX | z * 256;
                float zz = z + chunkZ;
                for (int y = yMin; y < yMax; ++y) {
                    int index;
                    float distance;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y - yMin) * zSize + z - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    float distanceAbove = distance = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx, (float)y, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx, (float)(y + 1), zz)) <= 1.0f && y - 1 == terrainYY) {
                        index = indexBase | y + 1;
                        blockArray[index] = this.light.getBlock();
                        metaArray[index] = this.light.getMetadata();
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y;
                    if (isHollow && distance <= hollowSize) {
                        if (y == terrainY) {
                            blockArray[index] = this.grass.getBlock();
                            metaArray[index] = this.grass.getMetadata();
                            continue;
                        }
                        if (y < terrainY) {
                            blockArray[index] = this.dirt.getBlock();
                            metaArray[index] = this.dirt.getMetadata();
                            continue;
                        }
                        blockArray[index] = Blocks.field_150350_a;
                        metaArray[index] = 0;
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand.nextBoolean()) {
                            blockArray[index] = core.block;
                            metaArray[index] = core.meta;
                            continue;
                        }
                        blockArray[index] = this.asteroidStoneBlocks[0].getBlock();
                        metaArray[index] = this.asteroidStoneBlocks[0].getMetadata();
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        blockArray[index] = shell.block;
                        metaArray[index] = shell.meta;
                        continue;
                    }
                    blockArray[index] = this.asteroidStoneBlocks[1].getBlock();
                    metaArray[index] = this.asteroidStoneBlocks[1].getMetadata();
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x = xMin; x < xMax; ++x) {
                indexXY = (x - xMin) * ySize - yMin;
                indexXZ = (x - xMin) * zSize - zMin;
                distanceX = asteroidX - (x + chunkX);
                distanceX *= distanceX;
                indexBaseX = x * 256 << 4;
                for (int z = zMin; z < zMax; ++z) {
                    float sizeY = (float)size + sizeYArray[indexXZ + z];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z + chunkZ);
                    distanceZ *= distanceZ;
                    int indexBase = indexBaseX | z * 256;
                    for (int y = yMin; y < yMax; ++y) {
                        float sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY = asteroidY - y;
                        distanceY *= distanceY;
                        float distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)y, (float)(z + chunkZ))) <= 1.0f)) continue;
                        int index = indexBase | y;
                        int indexAbove = indexBase | y + 1;
                        if (Blocks.field_150350_a != blockArray[indexAbove] || blockArray[index] != this.asteroidStoneBlocks[0].getBlock() && blockArray[index] != this.grass.getBlock() || this.rand.nextInt(20) != 0) continue;
                        blockArray[index] = this.light.getBlock();
                        metaArray[index] = this.light.getMetadata();
                    }
                }
            }
        }
    }

    private final void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private final int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private final int getTerrainHeightAt(int x, int z, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        this.rand.setSeed((long)p_73154_1_ * 341873128712L + (long)p_73154_2_ * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(p_73154_1_, p_73154_2_, ids, meta, false);
        Chunk curChunk = new Chunk(this.worldObj, ids, meta, p_73154_1_, p_73154_2_);
        byte[] chunkBiomeArray = curChunk.func_76605_m();
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            chunkBiomeArray[i] = (byte)BiomeGenBaseAsteroids.asteroid.field_76756_M;
        }
        this.generateSkylightMap(curChunk, p_73154_1_, p_73154_2_);
        return curChunk;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    protected int getCountInNegXDirection(IChunkProvider world, int x, int y, int z, int maxLength, boolean isAir) {
        int count = 0;
        for (int i = 0; i < maxLength && this.worldObj.func_147439_a(x - i - 1, y, z) instanceof BlockAir == isAir; ++i) {
            ++count;
        }
        return count;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int x = p_73153_2_ << 4;
        int z = p_73153_3_ << 4;
        if (!CHUNKS_DONE.add(new BlockVec3(x, 0, z))) {
            return;
        }
        BlockFalling.field_149832_M = true;
        this.worldObj.func_72807_a(x + 16, z + 16);
        BlockFalling.field_149832_M = false;
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)p_73153_2_ * var7 + (long)p_73153_3_ * var9 ^ this.worldObj.func_72905_C());
        if (this.rand.nextBoolean()) {
            double density = (double)this.asteroidDensity.getNoise((float)(p_73153_2_ * 16), (float)(p_73153_3_ * 16)) * 0.54;
            double numOfBlocks = this.clamp(this.randFromPoint(p_73153_2_, p_73153_3_), 0.4, 1.0) * 200.0 * density + 50.0;
            int y0 = this.rand.nextInt(2);
            int yRange = 160;
            int i = 0;
            while ((double)i < numOfBlocks) {
                int y = this.rand.nextInt(160) + 48;
                if (y0 == y / 16 % 2) {
                    int px = x + this.rand.nextInt(16);
                    int pz = z + this.rand.nextInt(16);
                    Block block = this.asteroidStoneBlocks[1].getBlock();
                    byte meta = this.asteroidStoneBlocks[1].getMetadata();
                    for (BlockMetaPair b : this.extraOreGen.keySet()) {
                        int chance = this.extraOreGen.get(b);
                        if (this.rand.nextInt(chance) != 0) continue;
                        block = b.getBlock();
                        meta = b.getMetadata();
                        break;
                    }
                    this.worldObj.func_147465_d(px, y, pz, block, (int)meta, 2);
                    int count = 7;
                    if (!(this.worldObj.func_147439_a(px - 1, y, pz) instanceof BlockAir)) {
                        count = 1;
                    } else if (!(this.worldObj.func_147439_a(px - 2, y, pz) instanceof BlockAir)) {
                        count = 3;
                    } else if (!(this.worldObj.func_147439_a(px - 3, y, pz) instanceof BlockAir)) {
                        count = 5;
                    } else if (!(this.worldObj.func_147439_a(px - 4, y, pz) instanceof BlockAir)) {
                        count = 6;
                    }
                    count = this.adjustBrightnessValue(count);
                    this.worldObj.func_72915_b(EnumSkyBlock.Block, px - 1, y, pz, count);
                }
                ++i;
            }
        }
        if (this.largeAsteroidsLastChunkX != p_73153_2_ || this.largeAsteroidsLastChunkZ != p_73153_3_) {
            this.generateTerrain(p_73153_2_, p_73153_3_, null, null, true);
        }
        this.rand.setSeed((long)p_73153_2_ * var7 + (long)p_73153_3_ * var9 ^ this.worldObj.func_72905_C());
        if (!this.largeAsteroids.isEmpty()) {
            for (AsteroidData asteroidIndex : this.largeAsteroids) {
                int k;
                int i;
                if (!asteroidIndex.isHollow) continue;
                float[] sizeYArray = asteroidIndex.sizeYArray;
                int xMin = asteroidIndex.xMinArray;
                int zMin = asteroidIndex.zMinArray;
                int zSize = asteroidIndex.zSizeArray;
                int asteroidY = asteroidIndex.asteroidYArray;
                int asteroidSize = asteroidIndex.asteroidSizeArray;
                boolean treesdone = false;
                for (WorldGenData data : this.generatorsTrees) {
                    int k2;
                    int i2;
                    if (this.rand.nextInt(data.chance) != 0) continue;
                    for (int tries = 0; tries < 5 && !data.worldGen.func_76484_a(this.worldObj, this.rand, i2 = this.rand.nextInt(16) + x + 8, this.getTerrainHeightAt(i2 - x, (k2 = this.rand.nextInt(16) + z + 8) - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k2); ++tries) {
                    }
                    treesdone = true;
                    break;
                }
                if (!treesdone || this.rand.nextInt(2) == 0) {
                    for (WorldGenData data : this.generatorsGrass) {
                        if (this.rand.nextInt(data.chance) != 0) continue;
                        i = this.rand.nextInt(16) + x + 8;
                        k = this.rand.nextInt(16) + z + 8;
                        data.worldGen.func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                    }
                }
                for (WorldGenData data : this.generatorsLakes) {
                    if (this.rand.nextInt(data.chance) != 0) continue;
                    i = this.rand.nextInt(16) + x + 8;
                    k = this.rand.nextInt(16) + z + 8;
                    data.worldGen.func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
            }
        }
        for (int xx = 0; xx < 16; ++xx) {
            int xPos = x + xx;
            for (int zz = 0; zz < 16; ++zz) {
                int zPos = z + zz;
                for (int y = 16; y < 240; ++y) {
                    this.worldObj.func_147463_c(EnumSkyBlock.Block, xPos, y, zPos);
                }
            }
        }
    }

    public void generateSkylightMap(Chunk chunk, int cx, int cz) {
        for (int j = 0; j < 16; ++j) {
            if (chunk.func_76587_i()[j] != null) continue;
            chunk.func_76587_i()[j] = new ExtendedBlockStorage(j << 4, false);
        }
        int i = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int j = 0; j < 16; ++j) {
            block2: for (int k = 0; k < 16; ++k) {
                chunk.field_76638_b[j + (k << 4)] = -999;
                for (int y = i + 15; y > 0; --y) {
                    if (chunk.func_150808_b(j, y - 1, k) == 0) {
                        continue;
                    }
                    chunk.field_76634_f[k << 4 | j] = y;
                    if (y >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = y;
                    continue block2;
                }
            }
        }
        for (AsteroidData a : this.largeAsteroids) {
            int yMin = a.asteroidYArray - a.asteroidSizeArray;
            int yMax = a.asteroidYArray + a.asteroidSizeArray;
            int xMin = a.xMinArray;
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax > 255) {
                yMax = 255;
            }
            if (xMin == 0) {
                xMin = 1;
            }
            for (int x = a.xMax - 1; x >= xMin; --x) {
                for (int z = a.zMinArray; z < a.zMax; ++z) {
                    for (int y = yMin; y < yMax; ++y) {
                        if (!(chunk.func_150810_a(x - 1, y, z) instanceof BlockAir) || chunk.func_150810_a(x, y, z) instanceof BlockAir) continue;
                        int count = 2;
                        if (x > 1 && chunk.func_150810_a(x - 2, y, z) instanceof BlockAir) {
                            count += 2;
                        }
                        if (x > 2) {
                            if (chunk.func_150810_a(x - 3, y, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 3, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 3, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && chunk.func_150810_a(x - 3, y, z - 1) instanceof BlockAir) {
                                ++count;
                            }
                            if (z < 15 && chunk.func_150810_a(x - 3, y, z + 1) instanceof BlockAir) {
                                ++count;
                            }
                        }
                        if (x > 3) {
                            if (chunk.func_150810_a(x - 4, y, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 4, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 4, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && !(chunk.func_150810_a(x - 4, y, z - 1) instanceof BlockAir)) {
                                ++count;
                            }
                            if (z < 15 && !(chunk.func_150810_a(x - 4, y, z + 1) instanceof BlockAir)) {
                                ++count;
                            }
                        }
                        count = this.adjustBrightnessValue(count);
                        chunk.func_150807_a(x - 1, y, z, GCBlocks.brightAir, 15 - count);
                        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76677_d(x - 1, y & 0xF, z, count + 2);
                    }
                }
            }
        }
        chunk.field_76643_l = true;
    }

    protected int adjustBrightnessValue(int count) {
        if ((count += 2) > 12) {
            count = 12;
        }
        return count;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i1 = -i0; i1 <= i0; ++i1) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i1;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + 16; x += 2) {
            for (int z = z0; z < z0 + 16; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static class WorldGenData {
        public int chance;
        public WorldGenerator worldGen;

        public WorldGenData(WorldGenerator worldGen, int chance) {
            this.chance = chance;
            this.worldGen = worldGen;
        }
    }

    private static class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidYArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidX, int asteroidY, int asteroidZ) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidYArray = asteroidY;
        }
    }
}

