/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class HolidayHelper {
    static Calendar curTime = Calendar.getInstance();
    static Calendar holidayStart = Calendar.getInstance();
    static Calendar holidayEnd = Calendar.getInstance();

    private HolidayHelper() {
    }

    public static boolean isNewYear() {
        HolidayHelper.setDate(holidayStart, 11, 31, false);
        HolidayHelper.setDate(holidayEnd, 0, 2, true);
        holidayEnd.set(1, 2);
        return HolidayHelper.dateCheck();
    }

    public static boolean isValentinesDay() {
        HolidayHelper.setDate(holidayStart, 1, 13, false);
        HolidayHelper.setDate(holidayEnd, 1, 15, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isStPatricksDay() {
        HolidayHelper.setDate(holidayStart, 2, 16, false);
        HolidayHelper.setDate(holidayEnd, 2, 18, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isAprilFools() {
        HolidayHelper.setDate(holidayStart, 2, 31, false);
        HolidayHelper.setDate(holidayEnd, 3, 2, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isEarthDay() {
        HolidayHelper.setDate(holidayStart, 3, 21, false);
        HolidayHelper.setDate(holidayEnd, 3, 23, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isEaster() {
        int n;
        int n2 = Calendar.getInstance().get(1);
        if (n2 <= 1582) {
            return false;
        }
        int n3 = n2 % 19 + 1;
        int n4 = n2 / 100 + 1;
        int n5 = 3 * n4 / 4 - 12;
        int n6 = (8 * n4 + 5) / 25 - 5;
        int n7 = 5 * n2 / 4 - n5 - 10;
        int n8 = (11 * n3 + 20 + n6 - n5) % 30;
        if (n8 == 25 && n3 > 11 || n8 == 24) {
            ++n8;
        }
        n += 30 * ((n = 44 - n8) < 21 ? 1 : 0);
        n += 7 - (n7 + n) % 7;
        GregorianCalendar gregorianCalendar = n > 31 ? new GregorianCalendar(n2, 3, n - 31) : new GregorianCalendar(n2, 2, n);
        HolidayHelper.setDate(holidayStart, gregorianCalendar.get(2), gregorianCalendar.get(5) - 1, false);
        HolidayHelper.setDate(holidayEnd, gregorianCalendar.get(2), gregorianCalendar.get(5) + 1, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isUSIndependenceDay() {
        HolidayHelper.setDate(holidayStart, 6, 3, false);
        HolidayHelper.setDate(holidayEnd, 6, 5, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isHalloween() {
        HolidayHelper.setDate(holidayStart, 9, 30, false);
        HolidayHelper.setDate(holidayEnd, 10, 1, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isVeteransDay() {
        HolidayHelper.setDate(holidayStart, 10, 10, false);
        HolidayHelper.setDate(holidayEnd, 10, 12, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isCAThanksgiving() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, Calendar.getInstance().get(1));
        calendar.set(2, 9);
        calendar.set(7, 2);
        calendar.set(8, 2);
        HolidayHelper.setDate(holidayStart, 9, calendar.get(5) - 1, false);
        HolidayHelper.setDate(holidayEnd, 9, calendar.get(5) + 1, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isUSThanksgiving() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, Calendar.getInstance().get(1));
        calendar.set(2, 10);
        calendar.set(7, 5);
        calendar.set(8, 4);
        HolidayHelper.setDate(holidayStart, 10, calendar.get(5) - 1, false);
        HolidayHelper.setDate(holidayEnd, 10, calendar.get(5) + 1, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isChristmas() {
        HolidayHelper.setDate(holidayStart, 11, 24, false);
        HolidayHelper.setDate(holidayEnd, 11, 26, true);
        return HolidayHelper.dateCheck();
    }

    public static boolean isBoxingDay() {
        HolidayHelper.setDate(holidayStart, 11, 25, false);
        HolidayHelper.setDate(holidayEnd, 11, 27, true);
        return HolidayHelper.dateCheck();
    }

    static void setDate(Calendar calendar, int n, int n2, boolean bl) {
        calendar.clear();
        calendar.set(1, Calendar.getInstance().get(1));
        calendar.set(2, n);
        calendar.set(5, n2);
        if (bl) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
    }

    static boolean dateCheck() {
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }
}

