/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.api.audio;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Vec3;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.network.PacketType;
import pl.asie.lib.network.Packet;

public abstract class AudioPacket {
    private static int _idGen;
    public final IAudioSource source;
    public final int id;
    public final byte volume;
    private final Set<IAudioReceiver> receivers = new HashSet<IAudioReceiver>();

    private static int getNewId() {
        return _idGen++;
    }

    public AudioPacket(IAudioSource source, byte volume) {
        this.id = AudioPacket.getNewId();
        this.source = source;
        this.volume = volume;
    }

    public Collection<IAudioReceiver> getReceivers() {
        return Collections.unmodifiableSet(this.receivers);
    }

    public void addReceiver(IAudioReceiver receiver) {
        if (receiver.getSoundWorld() != null) {
            this.receivers.add(receiver);
        }
    }

    protected abstract void writeData(Packet var1) throws IOException;

    protected boolean canHearReceiver(EntityPlayerMP playerMP, IAudioReceiver receiver) {
        if (receiver.getSoundWorld().field_73011_w.field_76574_g != playerMP.field_70170_p.field_73011_w.field_76574_g) {
            return false;
        }
        int mdSq = receiver.getSoundDistance() * receiver.getSoundDistance();
        Vec3 pos = receiver.getSoundPos();
        double distSq = (pos.field_72450_a - playerMP.field_70165_t) * (pos.field_72450_a - playerMP.field_70165_t);
        distSq += (pos.field_72448_b - playerMP.field_70163_u) * (pos.field_72448_b - playerMP.field_70163_u);
        return (distSq += (pos.field_72449_c - playerMP.field_70161_v) * (pos.field_72449_c - playerMP.field_70161_v)) <= (double)mdSq;
    }

    public final void sendPacket() {
        try {
            for (EntityPlayerMP playerMP : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (playerMP == null || playerMP.field_70170_p == null) continue;
                HashSet<IAudioReceiver> receiversLocal = new HashSet<IAudioReceiver>();
                for (IAudioReceiver receiver : this.receivers) {
                    if (!this.canHearReceiver(playerMP, receiver)) continue;
                    receiversLocal.add(receiver);
                }
                if (receiversLocal.size() <= 0) continue;
                Packet pkt = Computronics.packet.create(PacketType.AUDIO_DATA.ordinal()).writeShort((short)AudioPacketRegistry.INSTANCE.getId(this.getClass())).writeInt(this.id).writeInt(this.source.getSourceId());
                this.writeData(pkt);
                pkt.writeShort((short)this.receivers.size());
                for (IAudioReceiver receiver : this.receivers) {
                    pkt.writeInt(receiver.getSoundWorld() != null ? receiver.getSoundWorld().field_73011_w.field_76574_g : 0);
                    Vec3 pos = receiver.getSoundPos();
                    pkt.writeFloat((float)pos.field_72450_a).writeFloat((float)pos.field_72448_b).writeFloat((float)pos.field_72449_c).writeShort((short)receiver.getSoundDistance()).writeByte(this.volume).writeString(receiver.getID());
                }
                Computronics.packet.sendTo(pkt, playerMP);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

