/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sun.misc.Unsafe;

public class FieldReflectionUtils {
    private static final Unsafe UNSAFE;
    private static final MethodHandles.Lookup mhLookup;

    private FieldReflectionUtils() {
    }

    @Nonnull
    public static <T> ClassFields<T> ofClass(@Nonnull Class<T> klass) {
        return new ClassFields(Objects.requireNonNull(klass));
    }

    static {
        mhLookup = MethodHandles.lookup();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class ClassFields<C> {
        public final Class<C> klass;

        private ClassFields(Class<C> klass) {
            this.klass = klass;
        }

        private java.lang.reflect.Field getCheckedFieldImpl(@Nonnull LookupType strategy, @Nonnull String name, @Nullable Class<?> expectedType) {
            Class<?> realType;
            java.lang.reflect.Field javaField = strategy.lookup(this.klass, name);
            if (javaField == null) {
                return null;
            }
            if (expectedType != null && !(realType = javaField.getType()).equals(expectedType)) {
                throw new ClassCastException(String.format("Trying to access field %s#%s of type %s as type %s", this.klass.getName(), name, realType.getName(), expectedType.getName()));
            }
            return javaField;
        }

        public Field<?> getUntypedField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), null);
            if (javaField == null) {
                return null;
            }
            return new Field(javaField, Object.class);
        }

        public <F> Field<F> getField(@Nonnull LookupType strategy, @Nonnull String name, @Nonnull Class<F> expectedType) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Objects.requireNonNull(expectedType));
            if (javaField == null) {
                return null;
            }
            return new Field(javaField, expectedType);
        }

        public Field<Boolean> getBooleanField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Boolean.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Boolean>(javaField, Boolean.class);
        }

        public Field<Byte> getByteField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Byte.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Byte>(javaField, Byte.class);
        }

        public Field<Short> getShortField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Short.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Short>(javaField, Short.class);
        }

        public Field<Integer> getIntField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Integer.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Integer>(javaField, Integer.class);
        }

        public Field<Long> getLongField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Long.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Long>(javaField, Long.class);
        }

        public Field<Character> getCharField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Character.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Character>(javaField, Character.class);
        }

        public Field<Float> getFloatField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Float.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Float>(javaField, Float.class);
        }

        public Field<Double> getDoubleField(@Nonnull LookupType strategy, @Nonnull String name) {
            java.lang.reflect.Field javaField = this.getCheckedFieldImpl(Objects.requireNonNull(strategy), Objects.requireNonNull(name), Double.TYPE);
            if (javaField == null) {
                return null;
            }
            return new Field<Double>(javaField, Double.class);
        }

        public class Field<F> {
            public final java.lang.reflect.Field javaField;
            public final Class<F> accessType;
            public final boolean isPrimitive;
            public final boolean isStatic;
            public final boolean isFinal;
            private final Function<C, F> getAccessor;
            private final BiConsumer<C, F> setAccessor;

            private Field(java.lang.reflect.Field javaField, Class<F> accessType) {
                javaField.setAccessible(true);
                this.javaField = javaField;
                this.accessType = accessType;
                this.isPrimitive = javaField.getType().isPrimitive();
                this.isStatic = Modifier.isStatic(javaField.getModifiers());
                this.isFinal = Modifier.isFinal(javaField.getModifiers());
                try {
                    MethodHandle exactGetterHandle;
                    MethodHandle getterHandle = mhLookup.unreflectGetter(this.javaField);
                    if (this.isStatic) {
                        exactGetterHandle = getterHandle.asType(MethodType.methodType(Object.class));
                        this.getAccessor = obj -> {
                            try {
                                return exactGetterHandle.invokeExact();
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        };
                    } else {
                        exactGetterHandle = getterHandle.asType(MethodType.methodType(Object.class, Object.class));
                        this.getAccessor = obj -> {
                            try {
                                return exactGetterHandle.invokeExact(obj);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        };
                    }
                    BiConsumer<Object, Object> setAccessor = null;
                    try {
                        MethodHandle setterHandle = mhLookup.unreflectSetter(javaField);
                        if (this.isStatic) {
                            MethodHandle exactSetterHandle = setterHandle.asType(MethodType.methodType(Void.TYPE, Object.class));
                            setAccessor = (obj, val) -> {
                                try {
                                    exactSetterHandle.invokeExact(val);
                                }
                                catch (Throwable e) {
                                    throw new RuntimeException(e);
                                }
                            };
                        } else {
                            MethodHandle exactSetterHandle = setterHandle.asType(MethodType.methodType(Void.TYPE, Object.class, Object.class));
                            setAccessor = (obj, val) -> {
                                try {
                                    exactSetterHandle.invokeExact(obj, val);
                                }
                                catch (Throwable e) {
                                    throw new RuntimeException(e);
                                }
                            };
                        }
                    }
                    catch (IllegalAccessException e) {
                        long fieldOffset;
                        Object staticBase = this.isStatic ? UNSAFE.staticFieldBase(javaField) : null;
                        long l = fieldOffset = this.isStatic ? UNSAFE.staticFieldOffset(javaField) : UNSAFE.objectFieldOffset(javaField);
                        if (!this.isPrimitive) {
                            setAccessor = (obj, val) -> UNSAFE.putObject(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, val);
                        }
                        Class<?> fieldType = javaField.getType();
                        if (fieldType.equals(Boolean.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putBoolean(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Boolean)val);
                        }
                        if (fieldType.equals(Byte.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putByte(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Byte)val);
                        }
                        if (fieldType.equals(Short.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putShort(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Short)val);
                        }
                        if (fieldType.equals(Integer.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putInt(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Integer)val);
                        }
                        if (fieldType.equals(Long.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putLong(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Long)val);
                        }
                        if (fieldType.equals(Character.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putChar(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, ((Character)val).charValue());
                        }
                        if (fieldType.equals(Float.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putFloat(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, ((Float)val).floatValue());
                        }
                        if (fieldType.equals(Double.TYPE)) {
                            setAccessor = (obj, val) -> UNSAFE.putDouble(this.unsafeBaseHelper(staticBase, obj, val), fieldOffset, (Double)val);
                        }
                        throw new IllegalStateException();
                    }
                    this.setAccessor = Objects.requireNonNull(setAccessor);
                }
                catch (IllegalAccessException e) {
                    throw new UnsupportedOperationException("Couldn't create a Field accessor for " + ClassFields.this.klass.getName() + "#" + javaField.getName(), e);
                }
            }

            private Object unsafeBaseHelper(Object staticBase, Object obj, Object value) {
                if (!this.isStatic && !ClassFields.this.klass.isInstance(obj)) {
                    throw new ClassCastException("Illegal reflective access to field of " + ClassFields.this.klass + " using object of type " + obj.getClass());
                }
                if (!this.accessType.isAssignableFrom(value.getClass())) {
                    throw new ClassCastException("Illegal reflective set of value of type " + value.getClass() + " to field of type " + this.javaField.getType());
                }
                return this.isStatic ? staticBase : obj;
            }

            public F getValue(C object) {
                return this.getAccessor.apply(object);
            }

            public void setValue(C object, F value) {
                this.setAccessor.accept(object, value);
            }
        }
    }

    public static enum LookupType {
        PUBLIC,
        DECLARED,
        DECLARED_IN_HIERARCHY;


        public Field lookup(Class<?> klass, String name) {
            switch (this) {
                case PUBLIC: {
                    try {
                        return klass.getField(name);
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
                case DECLARED: {
                    try {
                        return klass.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
                case DECLARED_IN_HIERARCHY: {
                    for (Class<?> currentClass = klass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                        try {
                            return currentClass.getDeclaredField(name);
                        }
                        catch (NoSuchFieldException e) {
                            continue;
                        }
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            return null;
        }
    }
}

