/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.TC;

import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicTinkerBerryCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ItemApi;

public class MagicMetalBerryCrop
extends BasicTinkerBerryCrop {
    public String name() {
        return "Magic Metal Berry";
    }

    @Override
    public int tier() {
        return 7;
    }

    @Override
    protected String hasBlock() {
        return "";
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        boolean r = ConfigValues.debug ? crop.getSize() < 4 : crop.getSize() < 1 || crop.getSize() == 3 && (crop.isBlockBelow("blockThaumium") || crop.isBlockBelow("blockThauminite") || crop.isBlockBelow("blockIron") || crop.isBlockBelow("blockVoid")) || crop.getLightLevel() <= 10 && crop.getSize() < 3;
        return r;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 4;
    }

    public ItemStack getGain(ICropTile crop) {
        if (crop.isBlockBelow("blockThaumium") || crop.isBlockBelow("blockIron")) {
            return (ItemStack)OreDictionary.getOres((String)"nuggetThaumium").get(OreDictionary.getOres((String)"nuggetThaumium").size() - 1);
        }
        if ((crop.isBlockBelow("blockVoid") || ConfigValues.debug) && OreDictionary.getOres((String)"nuggetVoid").size() != 0) {
            return (ItemStack)OreDictionary.getOres((String)"nuggetVoid").get(OreDictionary.getOres((String)"nuggetVoid").size() - 1);
        }
        if (crop.isBlockBelow("blockThauminite") && OreDictionary.getOres((String)"nuggetThauminite").size() != 0) {
            return (ItemStack)OreDictionary.getOres((String)"nuggetThauminite").get(OreDictionary.getOres((String)"nuggetThauminite").size() - 1);
        }
        return null;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Needs a block of Thaumium, Iron, Thauminite or Void Below to fully mature.", "Drops the Magic-Metal that is underneath (Iron will drop Thaumium)", "Matures fastest with Thaumium under it.", "Needs a light level below or equal to 10 to fully mature.");
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (crop.getSize() == 2) {
            return 1200;
        }
        if (crop.getSize() == 3 && crop.isBlockBelow("blockThaumium")) {
            return 1800;
        }
        if (crop.getSize() == 3 && (crop.isBlockBelow("blockVoid") || crop.isBlockBelow("blockThauminite") || crop.isBlockBelow("blockIron"))) {
            return 3300;
        }
        return 500;
    }

    public String[] attributes() {
        return new String[]{"OreBerry", "Magic", "Metal", "Thaumium", "Void"};
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        CCropUtility.damageEntity(entity, 1.0f);
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public ItemStack getDisplayItem() {
        return ItemApi.getItem((String)"itemResource", (int)17);
    }
}

