/*
 * Decompiled with CFR 0.152.
 */
package emt.gthandler.common.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class EssentiaHatch
extends GT_MetaTileEntity_Hatch_Input {
    private static int ApTe = (int)Math.ceil(Aspect.aspects.size() / GT_Values.V.length);
    private AspectList current = new AspectList();

    public EssentiaHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public EssentiaHatch(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public EssentiaHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public boolean addAspectList(AspectList A) {
        if ((this.mTier + 1) * ApTe > A.size() + this.current.size()) {
            if (this.current.visSize() + A.visSize() < (this.mTier + 1) * ApTe * 64) {
                this.current.add(A);
            }
            return true;
        }
        return false;
    }

    public void setCurrent(AspectList List2) {
        this.current = List2;
    }

    public AspectList getAspects() {
        return this.current;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new EssentiaHatch("Essentia Hatch " + GT_Values.VN[this.mTier], (int)this.mTier, this.getDescription(), this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    public String[] getInfoData() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("This Essentia-Hatch contains:");
        for (Aspect A : this.current.aspects.keySet()) {
            list.add(A.getName() + ": " + Integer.toString(this.current.getAmount(A)));
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    public String[] getDescription() {
        return new String[]{"Essentia Hatch for usage in Multiblocks", "Can only be filled with the Essentia Filler", "Can hold " + Integer.toString(ApTe * (this.mTier + 1)) + " Different Essentia Types", "Can hold " + Integer.toString(64 * ApTe * (this.mTier + 1)) + " Essentia in total"};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public void saveNBTData(NBTTagCompound var1) {
        NBTTagList tlist = new NBTTagList();
        Aspect[] aspectA = this.current.getAspects();
        for (int i = 0; i < aspectA.length; ++i) {
            Aspect aspect = aspectA[i];
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.current.getAmount(aspect));
            tlist.func_74742_a((NBTBase)f);
        }
        var1.func_74782_a("Aspects", (NBTBase)tlist);
        super.saveNBTData(var1);
    }

    public void loadNBTData(NBTTagCompound var1) {
        this.current = new AspectList();
        NBTTagList tlist = var1.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.current.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
        super.loadNBTData(var1);
    }

    public int fuelleft() {
        int ret = 0;
        for (Aspect A : this.current.aspects.keySet()) {
            ret += this.current.getAmount(A);
        }
        return ret;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection aSide, ItemStack aStack) {
        return false;
    }

    public int getCapacity() {
        return 0;
    }
}

